/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.item;

import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemEnergyCapability
implements ICapabilityProvider,
IEnergyStorage {
    private final ItemStack itemStack;
    private final EnergyStorage energyStorage;
    private final LazyOptional<IEnergyStorage> lazyEnergyStorage;

    public ItemEnergyCapability(ItemStack itemStack, EnergyStorage energyStorage) {
        this.itemStack = itemStack;
        this.energyStorage = energyStorage;
        if (itemStack.m_41784_().m_128441_("energy")) {
            this.energyStorage.deserializeNBT(itemStack.m_41784_().m_128423_("energy"));
        }
        this.lazyEnergyStorage = LazyOptional.of(() -> this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return LazyOptional.empty();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int ret = this.energyStorage.receiveEnergy(maxReceive, simulate);
        if (!simulate) {
            this.itemStack.m_41784_().m_128365_("energy", this.energyStorage.serializeNBT());
        }
        return ret;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int ret = this.energyStorage.extractEnergy(maxExtract, simulate);
        if (!simulate) {
            this.itemStack.m_41784_().m_128365_("energy", this.energyStorage.serializeNBT());
        }
        return ret;
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.energyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.energyStorage.canReceive();
    }
}

