/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.item;

import com.github.x3r.mekanism_weaponry.common.item.addon.EnergyUsageChipItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.FireRateChipItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.GunAddonItem;
import com.github.x3r.mekanism_weaponry.common.packet.MekanismWeaponryPacketHandler;
import com.github.x3r.mekanism_weaponry.common.packet.ReloadGunClientPacket;
import com.github.x3r.mekanism_weaponry.common.registry.SoundRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public abstract class GunItem
extends Item {
    private final int cooldown;
    private final int energyUsage;
    private final int reloadTime;

    protected GunItem(Item.Properties pProperties, int cooldown, int energyUsage, int reloadTime) {
        super(pProperties.m_41487_(1).setNoRepair().m_41497_(Rarity.UNCOMMON));
        this.cooldown = cooldown;
        this.energyUsage = energyUsage;
        this.reloadTime = reloadTime;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (!this.getAddon(stack, 3).m_41619_()) {
            this.setScoping(stack, !this.isScoping(stack));
            player.m_36335_().m_41524_(stack.m_41720_(), 5);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        return super.m_7203_(level, player, usedHand);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.m_5776_() && !isSelected) {
            this.serverStoppedShooting(stack);
        }
    }

    public void tryStartReload(ItemStack stack, ServerPlayer player) {
        Item item = stack.m_41720_();
        if (item instanceof GunItem) {
            GunItem item2 = (GunItem)item;
            if (this.canReload(stack, player)) {
                item2.serverReload(stack, player);
                MekanismWeaponryPacketHandler.sendToClient(new ReloadGunClientPacket(), player);
            }
            if (!player.m_36335_().m_41519_(stack.m_41720_())) {
                player.m_284548_().m_6263_(null, player.m_146892_().f_82479_, player.m_146892_().f_82480_, player.m_146892_().f_82481_, (SoundEvent)SoundRegistry.GUN_OUT_OF_AMMO.get(), SoundSource.PLAYERS, 1.5f, 1.0f);
            }
        }
    }

    public boolean canReload(ItemStack stack, ServerPlayer serverPlayer) {
        return !serverPlayer.m_36335_().m_41519_(stack.m_41720_());
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"mekanism_weaponry.tooltip.gun_energy").m_130948_(Style.f_131099_.m_178520_(3125974)).m_7220_((Component)Component.m_237113_((String)String.format("%d/%d FE", this.getEnergyStorage(pStack).getEnergyStored(), this.getEnergyStorage(pStack).getMaxEnergyStored())).m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))));
        if (!Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"mekanism_weaponry.tooltip.gun_stats").m_130946_(" [SHIFT] ").m_130948_(Style.f_131099_.m_178520_(0x5C5C5C)));
        } else {
            this.addStatsTooltip(pStack, pTooltipComponents);
        }
        if (!Screen.m_96637_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"mekanism_weaponry.tooltip.gun_addons").m_130946_(" [CTRL] ").m_130948_(Style.f_131099_.m_178520_(0x5C5C5C)));
        } else {
            this.addAddonsTooltip(pStack, pTooltipComponents);
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public void addStatsTooltip(ItemStack stack, List<Component> tooltipComponents) {
        tooltipComponents.add((Component)Component.m_237115_((String)"mekanism_weaponry.tooltip.gun_stats").m_130948_(Style.f_131099_.m_178520_(0x5C5C5C)));
        tooltipComponents.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"mekanism_weaponry.tooltip.gun_cooldown")).m_130946_(": ").m_130948_(Style.f_131099_.m_178520_(9030029)).m_7220_((Component)Component.m_237113_((String)String.format("%d ticks", this.getCooldown(stack))).m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))));
        tooltipComponents.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"mekanism_weaponry.tooltip.gun_energy_usage")).m_130946_(": ").m_130948_(Style.f_131099_.m_178520_(9030029)).m_7220_((Component)Component.m_237113_((String)String.format("%d / shot", this.getEnergyUsage(stack))).m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))));
        tooltipComponents.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"mekanism_weaponry.tooltip.gun_reload_time")).m_130946_(": ").m_130948_(Style.f_131099_.m_178520_(9030029)).m_7220_((Component)Component.m_237113_((String)String.format("%d ticks", this.reloadTime)).m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))));
    }

    public void addAddonsTooltip(ItemStack stack, List<Component> tooltipComponents) {
        tooltipComponents.add((Component)Component.m_237115_((String)"mekanism_weaponry.tooltip.gun_addons").m_130948_(Style.f_131099_.m_178520_(0x5C5C5C)));
        ItemStack[] addons = new ItemStack[5];
        for (int i = 0; i < addons.length; ++i) {
            addons[i] = this.getAddon(stack, i);
        }
        if (Arrays.stream(addons).allMatch(ItemStack::m_41619_)) {
            tooltipComponents.add((Component)Component.m_237115_((String)"mekanism_weaponry.tooltip.gun_no_addons"));
        } else {
            for (ItemStack addon : addons) {
                if (addon.m_41619_()) continue;
                tooltipComponents.add((Component)Component.m_237113_((String)" ").m_7220_(addon.m_41786_()));
            }
        }
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_41720_().equals(newStack.m_41720_());
    }

    public boolean isReady(ItemStack stack, ServerPlayer player, Level level) {
        long tick = level.m_46467_();
        return !player.m_36335_().m_41519_(stack.m_41720_()) && this.isOffCooldown(stack, tick) && this.hasSufficientEnergy(stack);
    }

    public int getCooldown(ItemStack stack) {
        return (int)Math.max(0.0f, (float)this.cooldown - this.getAddonMultiplier(stack, FireRateChipItem.class));
    }

    public int getEnergyUsage(ItemStack stack) {
        return (int)Math.max(0.0f, (float)this.energyUsage - 10.0f * this.getAddonMultiplier(stack, EnergyUsageChipItem.class));
    }

    public int getReloadTime(ItemStack stack) {
        return this.reloadTime;
    }

    public long getLastShotTick(ItemStack stack) {
        if (stack.m_41784_().m_128441_("last_shot_tick")) {
            return stack.m_41784_().m_128454_("last_shot_tick");
        }
        this.setLastShotTick(stack, 0L);
        return this.getLastShotTick(stack);
    }

    public void setLastShotTick(ItemStack stack, long tick) {
        stack.m_41784_().m_128356_("last_shot_tick", tick);
    }

    public boolean isOffCooldown(ItemStack stack, long tick) {
        return tick - this.getLastShotTick(stack) >= (long)this.getCooldown(stack);
    }

    public IEnergyStorage getEnergyStorage(ItemStack stack) {
        return (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).orElseThrow(() -> new RuntimeException("Missing energy capability"));
    }

    public boolean hasSufficientEnergy(ItemStack stack) {
        return this.getEnergyStorage(stack).getEnergyStored() >= this.energyUsage;
    }

    public ItemStack getAddon(ItemStack stack, int index) {
        switch (index) {
            case 0: {
                return this.getAddon(stack, "chip1");
            }
            case 1: {
                return this.getAddon(stack, "paint");
            }
            case 2: {
                return this.getAddon(stack, "chip2");
            }
            case 3: {
                return this.getAddon(stack, "scope");
            }
            case 4: {
                return this.getAddon(stack, "chip3");
            }
        }
        throw new IllegalArgumentException();
    }

    private ItemStack getAddon(ItemStack stack, String addonSlot) {
        if (stack.m_41784_().m_128441_(addonSlot)) {
            return ItemStack.m_41712_((CompoundTag)stack.m_41784_().m_128469_(addonSlot));
        }
        stack.m_41784_().m_128365_(addonSlot, (Tag)ItemStack.f_41583_.serializeNBT());
        return this.getAddon(stack, addonSlot);
    }

    public boolean hasAddon(ItemStack stack, Class<? extends GunAddonItem> addonClass) {
        for (int i = 0; i < 5; ++i) {
            if (!addonClass.isInstance(this.getAddon(stack, i).m_41720_())) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> getAddonsOfType(ItemStack stack, Class<? extends GunAddonItem> addonClass) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < 5; ++i) {
            ItemStack addonStack = this.getAddon(stack, i);
            if (!addonClass.isInstance(addonStack.m_41720_())) continue;
            list.add(addonStack);
        }
        return list;
    }

    public float getAddonMultiplier(ItemStack stack, Class<? extends GunAddonItem> addonClass) {
        float count = 0.0f;
        for (int i = 0; i < 5; ++i) {
            ItemStack addonStack = this.getAddon(stack, i);
            if (!addonClass.isInstance(addonStack.m_41720_())) continue;
            count += ((GunAddonItem)addonStack.m_41720_()).mul();
        }
        return count;
    }

    public void setAddon(ItemStack stack, ItemStack chipStack, int index) {
        switch (index) {
            case 0: {
                stack.m_41784_().m_128365_("chip1", (Tag)chipStack.serializeNBT());
                break;
            }
            case 1: {
                stack.m_41784_().m_128365_("paint", (Tag)chipStack.serializeNBT());
                break;
            }
            case 2: {
                stack.m_41784_().m_128365_("chip2", (Tag)chipStack.serializeNBT());
                break;
            }
            case 3: {
                stack.m_41784_().m_128365_("scope", (Tag)chipStack.serializeNBT());
                break;
            }
            case 4: {
                stack.m_41784_().m_128365_("chip3", (Tag)chipStack.serializeNBT());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean isShooting(ItemStack stack) {
        if (stack.m_41784_().m_128441_("is_shooting")) {
            return stack.m_41784_().m_128471_("is_shooting");
        }
        this.setShooting(stack, false);
        return this.isShooting(stack);
    }

    public void setShooting(ItemStack stack, boolean shooting) {
        stack.m_41784_().m_128379_("is_shooting", shooting);
    }

    public boolean isScoping(ItemStack stack) {
        if (stack.m_41784_().m_128441_("is_scoping")) {
            return stack.m_41784_().m_128471_("is_scoping");
        }
        this.setScoping(stack, false);
        return this.isScoping(stack);
    }

    public void setScoping(ItemStack stack, boolean scoping) {
        stack.m_41784_().m_128379_("is_scoping", scoping);
    }

    public abstract void serverShoot(ItemStack var1, ServerPlayer var2);

    public abstract void clientShoot(ItemStack var1, Player var2);

    public abstract void serverReload(ItemStack var1, ServerPlayer var2);

    public abstract void clientReload(ItemStack var1, Player var2);

    public void serverStoppedShooting(ItemStack stack) {
        this.setShooting(stack, false);
    }

    public abstract boolean canInstallAddon(ItemStack var1, ItemStack var2);
}

