/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.item;

import com.github.x3r.mekanism_weaponry.MekanismWeaponryConfig;
import com.github.x3r.mekanism_weaponry.client.renderer.GauntletRenderer;
import com.github.x3r.mekanism_weaponry.common.item.ItemEnergyCapability;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GauntletItem
extends Item
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final int energyUsage = MekanismWeaponryConfig.CONFIG.getGauntletEnergyUsage();

    public GauntletItem(Item.Properties properties) {
        super(properties.setNoRepair().m_41487_(1).m_246768_(new FeatureFlag[0]).m_41497_(Rarity.UNCOMMON));
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot.equals((Object)EquipmentSlot.MAINHAND)) {
            if (this.hasSufficientEnergy(stack)) {
                ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", MekanismWeaponryConfig.CONFIG.getGauntletDamage(), AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -3.0, AttributeModifier.Operation.ADDITION));
                return builder.build();
            }
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -3.6, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return ImmutableMultimap.of();
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ItemEnergyCapability(stack, new EnergyStorage(MekanismWeaponryConfig.CONFIG.getGauntletEnergyCapacity(), MekanismWeaponryConfig.CONFIG.getGauntletEnergyTransfer()));
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.hasSufficientEnergy(stack)) {
            if (!target.m_9236_().m_5776_()) {
                this.getEnergyStorage(stack).extractEnergy(this.energyUsage, false);
                target.m_147240_(0.55, -attacker.m_20154_().f_82479_, -attacker.m_20154_().f_82481_);
                target.m_246865_(new Vec3(0.0, 0.35, 0.0));
                target.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12311_, SoundSource.PLAYERS, 1.0f, 1.0f);
                ((ServerLevel)target.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, target.m_20185_(), target.m_20186_(), target.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        } else {
            target.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11797_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public boolean hasSufficientEnergy(ItemStack stack) {
        return this.getEnergyStorage(stack).getEnergyStored() >= this.energyUsage;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"mekanism_weaponry.tooltip.gun_energy").m_130948_(Style.f_131099_.m_178520_(3125974)).m_7220_((Component)Component.m_237113_((String)String.format("%d/%d FE", this.getEnergyStorage(pStack).getEnergyStored(), this.getEnergyStorage(pStack).getMaxEnergyStored())).m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))));
    }

    public IEnergyStorage getEnergyStorage(ItemStack stack) {
        return (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).orElseThrow(() -> new RuntimeException("Missing energy capability"));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GauntletRenderer renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new GauntletRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

