/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.item;

import com.github.x3r.mekanism_weaponry.common.item.GunItem;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemDecorator;
import org.jetbrains.annotations.Nullable;

public abstract class AmmoGunItem
extends GunItem {
    protected final int maxAmmo;

    protected AmmoGunItem(Item.Properties pProperties, int cooldown, int energyUsage, int reloadTime, int maxAmmo) {
        super(pProperties, cooldown, energyUsage, reloadTime);
        this.maxAmmo = maxAmmo;
    }

    @Override
    public boolean isReady(ItemStack stack, ServerPlayer player, Level level) {
        return this.hasAmmo(stack) && super.isReady(stack, player, level);
    }

    @Override
    public boolean canReload(ItemStack stack, ServerPlayer serverPlayer) {
        return super.canReload(stack, serverPlayer) && !this.getFirstAmmoStack(stack, serverPlayer).m_41619_();
    }

    public ItemStack getLoadedAmmo(ItemStack stack) {
        if (stack.m_41784_().m_128441_("loaded_ammo")) {
            return ItemStack.m_41712_((CompoundTag)stack.m_41784_().m_128469_("loaded_ammo"));
        }
        stack.m_41784_().m_128365_("loaded_ammo", (Tag)ItemStack.f_41583_.serializeNBT());
        return this.getLoadedAmmo(stack);
    }

    public void setLoadedAmmo(ItemStack stack, ItemStack ammoStack) {
        stack.m_41784_().m_128365_("loaded_ammo", (Tag)ammoStack.serializeNBT());
    }

    public void loadAmmo(ItemStack gunStack, ServerPlayer player) {
        ItemStack ammoInGun = this.getLoadedAmmo(gunStack);
        ItemStack ammoStack = this.getFirstAmmoStack(gunStack, player);
        int i = ammoInGun.m_41613_() + ammoStack.m_41613_() - this.maxAmmo;
        this.setLoadedAmmo(gunStack, new ItemStack((ItemLike)ammoStack.m_41720_(), Math.min(ammoInGun.m_41613_() + ammoStack.m_41613_(), this.maxAmmo)));
        ammoStack.m_41764_(Math.max(0, i));
        if (ammoInGun.m_41613_() < this.maxAmmo && !this.getFirstAmmoStack(gunStack, player).m_41619_()) {
            this.loadAmmo(gunStack, player);
        }
    }

    public abstract Predicate<ItemStack> isValidAmmo(ItemStack var1);

    public boolean ammoFitsInGun(ItemStack gunStack, ItemStack ammoStack) {
        ItemStack stackInGun = this.getLoadedAmmo(gunStack);
        if (stackInGun.m_41619_()) {
            return true;
        }
        return stackInGun.m_41613_() < this.maxAmmo && ammoStack.m_150930_(stackInGun.m_41720_());
    }

    public boolean hasAmmo(ItemStack gunStack) {
        return !this.getLoadedAmmo(gunStack).m_41619_();
    }

    public ItemStack getFirstAmmoStack(ItemStack gunStack, ServerPlayer player) {
        ItemStack offHandStack = player.m_21206_();
        if (this.isValidAmmo(gunStack).test(offHandStack) && this.ammoFitsInGun(gunStack, offHandStack)) {
            return offHandStack;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!this.isValidAmmo(gunStack).test(stack) || !this.ammoFitsInGun(gunStack, stack)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static IItemDecorator decorator() {
        return (guiGraphics, font, stack, xOffset, yOffset) -> {
            AmmoGunItem item = (AmmoGunItem)stack.m_41720_();
            float f = Math.min(1.0f, (float)item.getLoadedAmmo(stack).m_41613_() / (float)item.maxAmmo);
            guiGraphics.m_285944_(RenderType.m_286086_(), xOffset + 2, yOffset + 13, xOffset + 2 + 13, yOffset + 13 + 2, -16777216);
            int i = 0;
            while ((float)i < 13.0f * f) {
                guiGraphics.m_285944_(RenderType.m_286086_(), xOffset + 2 + i, yOffset + 13, xOffset + 2 + i + 1, yOffset + 13 + 1, -1);
                ++i;
            }
            return true;
        };
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"mekanism_weaponry.tooltip.gun_loaded_ammo").m_130948_(Style.f_131099_.m_178520_(12745632)).m_7220_((Component)Component.m_237113_((String)String.format("%d/%d Steel Rods", this.getLoadedAmmo(pStack).m_41613_(), this.maxAmmo)).m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

