/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.entity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class GunProjectileEntity
extends Projectile {
    protected final double damage;
    protected final Function<Entity, DamageSource> damageSource;

    protected GunProjectileEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
        this.damage = 0.0;
        this.damageSource = null;
    }

    public GunProjectileEntity(EntityType<? extends Projectile> pEntityType, Level pLevel, double damage, Function<Entity, DamageSource> damageSource) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
        this.m_20242_(true);
        this.damage = damage;
        this.damageSource = damageSource;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (this.f_19797_ > 300) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            this.handleCollisions();
        }
        this.m_146884_(this.m_20182_().m_82549_(this.m_20184_()));
    }

    private void handleCollisions() {
        Vec3 startVec = this.m_20182_();
        Vec3 endVec = this.m_20182_().m_82549_(this.m_20184_());
        List<BlockHitResult> blockCollisions = this.traceBlockCollisions(startVec, endVec);
        List<EntityHitResult> entityCollisions = this.traceEntityCollisions(startVec, endVec, this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0)));
        ArrayList<Object> collisions = new ArrayList<Object>();
        collisions.addAll(blockCollisions);
        collisions.addAll(entityCollisions);
        collisions.sort(Comparator.comparingDouble(o -> o.m_82450_().m_82557_(startVec)));
        for (HitResult hitResult : collisions) {
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                this.handleEntityCollision(entityHitResult);
            }
            if (!(hitResult instanceof BlockHitResult)) continue;
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            this.handleBlockCollision(blockHitResult);
        }
    }

    private void handleEntityCollision(EntityHitResult hitResult) {
        Entity entity = hitResult.m_82443_();
        if (!entity.equals((Object)this.m_19749_())) {
            entity.m_6469_(this.damageSource.apply(this.m_19749_()), (float)this.damage);
            Vec3 pos = hitResult.m_82450_();
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50330_.m_49966_()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 15, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void handleBlockCollision(BlockHitResult hitResult) {
        BlockState state = this.m_9236_().m_8055_(hitResult.m_82425_());
        if (state.m_60742_((BlockGetter)this.m_9236_(), hitResult.m_82425_(), CollisionContext.m_82749_()).m_83281_() || state.m_60771_((BlockGetter)this.m_9236_(), hitResult.m_82425_(), CollisionContext.m_82749_()).m_83281_()) {
            return;
        }
        Vec3 pos = hitResult.m_82450_();
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_9236_().m_8055_(hitResult.m_82425_())), pos.f_82479_, pos.f_82480_, pos.f_82481_, 15, 0.0, 0.0, 0.0, 1.0);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public List<BlockHitResult> traceBlockCollisions(Vec3 startVec, Vec3 endVec) {
        ArrayList<BlockHitResult> collisions = new ArrayList<BlockHitResult>();
        double scale = this.m_20191_().m_82309_() / endVec.m_82546_(startVec).m_82553_();
        Vec3 increment = endVec.m_82546_(startVec).m_82490_(scale);
        int i = 0;
        while ((double)i < 1.0 / scale) {
            Vec3 vPos = startVec.m_82549_(increment.m_82490_((double)i));
            BlockPos pos = new BlockPos(Mth.m_14107_((double)vPos.f_82479_), Mth.m_14107_((double)vPos.f_82480_), Mth.m_14107_((double)vPos.f_82481_));
            BlockState state = this.m_9236_().m_8055_(pos);
            if (!state.m_60795_()) {
                collisions.add(new BlockHitResult(vPos, Direction.m_122366_((double)vPos.f_82479_, (double)vPos.f_82480_, (double)vPos.f_82481_).m_122424_(), pos, true));
            }
            ++i;
        }
        return collisions;
    }

    public List<EntityHitResult> traceEntityCollisions(Vec3 startVec, Vec3 endVec, List<Entity> candidates) {
        ArrayList<EntityHitResult> collisions = new ArrayList<EntityHitResult>();
        candidates.forEach(entity -> {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                AABB box = livingEntity.m_20191_().m_82400_((double)0.1f);
                Optional hitPos = box.m_82371_(startVec, endVec);
                hitPos.ifPresent(vec3 -> collisions.add(new EntityHitResult((Entity)livingEntity, vec3)));
            }
        });
        return collisions;
    }
}

