/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.client.renderer;

import com.github.x3r.mekanism_weaponry.client.renderer.GunRenderer;
import com.github.x3r.mekanism_weaponry.common.item.TeslaMinigunItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3i;
import software.bernie.geckolib.model.DefaultedItemGeoModel;

public class TeslaMinigunRenderer
extends GunRenderer<TeslaMinigunItem> {
    private static final ResourceLocation LOCATION = new ResourceLocation("mekanism_weaponry", "textures/entity/electricity.png");
    private final RandomSource source;
    private ElectricityNode node = null;
    private long lastNodeGenTick = 0L;

    public TeslaMinigunRenderer() {
        super(new DefaultedItemGeoModel(new ResourceLocation("mekanism_weaponry", "tesla_minigun")));
        this.source = Minecraft.m_91087_().f_91074_.m_217043_();
    }

    public ResourceLocation getTextureLocation(TeslaMinigunItem animatable) {
        return new ResourceLocation("mekanism_weaponry", String.format("textures/item/tesla_minigun/tesla_minigun_%d.png", this.getTextureIndex()));
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (transformType != ItemDisplayContext.GUI && ((TeslaMinigunItem)stack.m_41720_()).isShooting(stack)) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.64, -0.25);
            poseStack.m_85841_(5.0f, 5.0f, 5.0f);
            if (transformType.m_269069_()) {
                poseStack.m_85841_(3.0f, 3.0f, 2.0f);
            }
            this.drawElectricity(this.buildNodes(4), poseStack, bufferSource, packedLight);
            poseStack.m_85849_();
        }
        super.m_108829_(stack, transformType, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private ElectricityNode buildNodes(int maxDepth) {
        if (this.lastNodeGenTick == Minecraft.m_91087_().f_91073_.m_46467_()) {
            return this.node;
        }
        this.node = this.buildNodes(new ElectricityNode(new Vec3(0.0, 0.0, 0.0)), 0, maxDepth);
        this.lastNodeGenTick = Minecraft.m_91087_().f_91073_.m_46467_();
        return this.node;
    }

    private ElectricityNode buildNodes(ElectricityNode curr, int depth, int maxDepth) {
        if (depth < maxDepth) {
            Vector3f dir = new Vector3f(0.0f, -0.01f, -4.0f);
            for (int i = 0; i < this.source.m_188503_(4); ++i) {
                ElectricityNode newNode = new ElectricityNode(new Vec3((double)((float)(curr.pos.f_82479_ + (double)(dir.x * 1.0f / (float)(depth + 2)) + this.source.m_188583_() * (double)Mth.m_14116_((float)((float)depth + 0.1f)) / 3.0)), (double)((float)(curr.pos.f_82480_ + (double)(dir.y * 1.0f / (float)(depth + 2)) + this.source.m_188583_() * (double)Mth.m_14116_((float)((float)depth + 0.1f)) / 4.0)), (double)((float)(curr.pos.f_82481_ + (double)(dir.z * 1.0f / (float)(depth + 2)) + this.source.m_188583_() * (double)Mth.m_14116_((float)((float)depth + 0.1f)) / 3.0))));
                this.buildNodes(newNode, depth + 1, maxDepth);
                curr.children.add(newNode);
            }
        }
        return curr;
    }

    private void drawElectricity(ElectricityNode node, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (node != null) {
            for (ElectricityNode electricityNode : node.children) {
                this.drawElectricity(node.pos, electricityNode.pos, poseStack, bufferSource, packedLight);
                this.drawElectricity(electricityNode, poseStack, bufferSource, packedLight);
            }
        }
    }

    private void drawElectricity(Vec3 v0, Vec3 v1, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)LOCATION));
        poseStack.m_85836_();
        Vec3 corner0 = new Vec3(v0.f_82479_, v0.f_82480_, v0.f_82481_);
        Vec3 corner1 = new Vec3(v1.f_82479_, v1.f_82480_, v1.f_82481_);
        this.longFace(poseStack, consumer, corner0, corner1, new Vector3i(0, 1, 0), packedLight);
        this.longFace(poseStack, consumer, corner0, corner1, new Vector3i(0, 0, 1), packedLight);
        this.longFace(poseStack, consumer, corner0, corner1, new Vector3i(0, -1, 0), packedLight);
        this.longFace(poseStack, consumer, corner0, corner1, new Vector3i(0, 0, -1), packedLight);
        poseStack.m_85849_();
    }

    private void longFace(PoseStack poseStack, VertexConsumer consumer, Vec3 corner0, Vec3 corner1, Vector3i cross, int packedLight) {
        Vec3 perp = corner0.m_82505_(corner1).m_82537_(new Vec3((double)cross.x, (double)cross.y, (double)cross.z)).m_82541_().m_82490_(0.01);
        this.vertex(poseStack, consumer, corner0.m_82546_(perp), cross.x, cross.y, cross.z, packedLight);
        this.vertex(poseStack, consumer, corner0.m_82549_(perp), cross.x, cross.y, cross.z, packedLight);
        this.vertex(poseStack, consumer, corner1.m_82549_(perp), cross.x, cross.y, cross.z, packedLight);
        this.vertex(poseStack, consumer, corner1.m_82546_(perp), cross.x, cross.y, cross.z, packedLight);
    }

    private void vertex(PoseStack poseStack, VertexConsumer consumer, Vec3 vec, int normalX, int normalY, int normalZ, int packedLight) {
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_).m_6122_(255, 255, 255, 255).m_7421_(16.0f, 16.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(poseStack.m_85850_().m_252943_(), (float)normalX, (float)normalY, (float)normalZ).m_5752_();
    }

    public static class ElectricityNode {
        private final Set<ElectricityNode> children = new HashSet<ElectricityNode>();
        private final Vec3 pos;

        public ElectricityNode(Vec3 pos) {
            this.pos = pos;
        }
    }
}

