/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.client.renderer;

import com.github.x3r.mekanism_weaponry.client.renderer.DynamicGeoItemRenderer;
import com.github.x3r.mekanism_weaponry.common.item.GunItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.PaintBucketItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;

public abstract class GunRenderer<T extends GunItem>
extends DynamicGeoItemRenderer<T> {
    private static ResourceLocation skinTexture;

    protected GunRenderer(GeoModel<T> model) {
        super(model);
    }

    @Override
    @Nullable
    protected ResourceLocation getTextureOverrideForBone(GeoBone bone, T animatable, float partialTick) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && bone.getParent() != null && bone.getParent().getParent() != null && bone.getParent().getParent().getName().equals("arms")) {
            return GunRenderer.getSkinResourceLocation(player);
        }
        return super.getTextureOverrideForBone(bone, animatable, partialTick);
    }

    private static ResourceLocation getSkinResourceLocation(LocalPlayer player) {
        if (skinTexture == null) {
            skinTexture = player.m_108560_();
        }
        return skinTexture;
    }

    @Override
    protected boolean boneRenderOverride(PoseStack poseStack, GeoBone bone, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.getName().equals("rightSlim") || bone.getName().equals("leftSlim")) {
            return !Minecraft.m_91087_().f_91074_.m_108564_().equals("slim");
        }
        if (bone.getName().equals("rightWide") || bone.getName().equals("leftWide")) {
            return !Minecraft.m_91087_().f_91074_.m_108564_().equals("default");
        }
        return super.boneRenderOverride(poseStack, bone, bufferSource, buffer, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (!this.renderPerspective.m_269069_() && bone.getName().equals("arms")) {
            return;
        }
        if (this.renderPerspective.m_269069_() && ((GunItem)((Object)animatable)).isScoping(this.getCurrentItemStack())) {
            return;
        }
        super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    protected IntIntPair computeTextureSize(ResourceLocation texture) {
        if (texture.equals((Object)skinTexture)) {
            return IntIntPair.of((int)64, (int)64);
        }
        if (texture.m_135827_().equals("minecraft") && texture.m_135815_().substring(0, texture.m_135815_().indexOf(47)).equals("skins")) {
            return IntIntPair.of((int)64, (int)64);
        }
        return super.computeTextureSize(texture);
    }

    protected int getTextureIndex() {
        if (((GunItem)this.animatable).hasAddon(this.currentItemStack, PaintBucketItem.class)) {
            return ((PaintBucketItem)((GunItem)this.animatable).getAddon(this.currentItemStack, 1).m_41720_()).getIndex();
        }
        return 0;
    }
}

