/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.client;

import com.github.x3r.mekanism_weaponry.MekanismWeaponry;
import com.github.x3r.mekanism_weaponry.client.renderer.PlasmaRenderer;
import com.github.x3r.mekanism_weaponry.client.renderer.RodRenderer;
import com.github.x3r.mekanism_weaponry.client.screen.WeaponWorkbenchScreen;
import com.github.x3r.mekanism_weaponry.common.item.AmmoGunItem;
import com.github.x3r.mekanism_weaponry.common.item.GunItem;
import com.github.x3r.mekanism_weaponry.common.item.HeatGunItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.PaintBucketItem;
import com.github.x3r.mekanism_weaponry.common.packet.DeactivateGunPacket;
import com.github.x3r.mekanism_weaponry.common.packet.MekanismWeaponryPacketHandler;
import com.github.x3r.mekanism_weaponry.common.packet.ReloadGunServerPacket;
import com.github.x3r.mekanism_weaponry.common.registry.EntityRegistry;
import com.github.x3r.mekanism_weaponry.common.registry.ItemRegistry;
import com.github.x3r.mekanism_weaponry.common.registry.MenuTypeRegistry;
import com.github.x3r.mekanism_weaponry.common.registry.ParticleRegistry;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="mekanism_weaponry", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    @Nullable
    private static ShaderInstance rendertypeElectricityShader;
    public static final KeyMapping RELOAD_MAPPING;
    private static float recoilO;
    private static float recoil;
    private static float scopeScale;

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(ClientSetup::pressKey);
        forgeEventBus.addListener(ClientSetup::onClientTick);
        forgeEventBus.addListener(ClientSetup::cameraSetupEvent);
        forgeEventBus.addListener(ClientSetup::renderGui);
        forgeEventBus.addListener(ClientSetup::computeFov);
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeRegistry.WEAPON_WORKBENCH.get()), WeaponWorkbenchScreen::new));
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        GunItem item;
        Item item2;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        while (RELOAD_MAPPING.m_90859_()) {
            if (!(stack.m_41720_() instanceof GunItem)) continue;
            MekanismWeaponryPacketHandler.sendToServer(new ReloadGunServerPacket());
        }
        if (!mc.f_91066_.f_92096_.m_90857_() && (item2 = stack.m_41720_()) instanceof GunItem && (item = (GunItem)item2).isShooting(stack)) {
            MekanismWeaponryPacketHandler.sendToServer(new DeactivateGunPacket());
        }
        recoilO = recoil;
        if (recoil > 0.0f && (double)(recoil = Mth.m_14116_((float)recoil)) < 0.01) {
            recoil = 0.0f;
        }
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityRegistry.PLASMA.get(), PlasmaRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.ROD.get(), RodRenderer::new);
    }

    public static void pressKey(InputEvent.InteractionKeyMappingTriggered event) {
        ItemStack stack = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        if (event.isAttack() && stack.m_41720_() instanceof GunItem) {
            event.setSwingHand(false);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(RELOAD_MAPPING);
    }

    public static void addRecoil(int i) {
        recoil += (float)i;
    }

    public static void cameraSetupEvent(ViewportEvent.ComputeCameraAngles event) {
        if (recoil > 0.0f) {
            event.setPitch((float)((double)event.getPitch() - Mth.m_14139_((double)event.getPartialTick(), (double)recoilO, (double)recoil)));
        }
    }

    @SubscribeEvent
    public static void registerItemDecorators(RegisterItemDecorationsEvent event) {
        event.register((ItemLike)ItemRegistry.PLASMA_RIFLE.get(), HeatGunItem.decorator());
        event.register((ItemLike)ItemRegistry.RAILGUN.get(), AmmoGunItem.decorator());
        event.register((ItemLike)ItemRegistry.TESLA_MINIGUN.get(), HeatGunItem.decorator());
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ParticleRegistry.ROD_TRAIL.get(), ParticleRegistry.RodTrailParticleProvider::new);
    }

    @SubscribeEvent
    public static void registerRenderTypes(RegisterShadersEvent event) {
        ResourceProvider provider = event.getResourceProvider();
        try {
            event.registerShader(new ShaderInstance(provider, new ResourceLocation("mekanism_weaponry", "electricity"), DefaultVertexFormat.f_85812_), shaderInstance -> {
                rendertypeElectricityShader = shaderInstance;
            });
        }
        catch (IOException e) {
            MekanismWeaponry.LOGGER.warn("Failed to load shader", (Throwable)e);
        }
    }

    public static ShaderInstance getElectricityShader() {
        return Objects.requireNonNull(rendertypeElectricityShader, "Attempted to get shader before they have finished loading.");
    }

    public static void renderGui(RenderGuiEvent.Post event) {
        LocalPlayer player;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91066_.m_92176_().m_90612_() && (player = minecraft.f_91074_) != null) {
            GunItem gunItem;
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            scopeScale = Mth.m_14179_((float)(0.5f * Minecraft.m_91087_().m_91297_()), (float)scopeScale, (float)1.0f);
            Item item = stack.m_41720_();
            if (item instanceof GunItem && (gunItem = (GunItem)item).isScoping(stack)) {
                ClientSetup.renderScopeOverlay(event.getGuiGraphics(), ClientSetup.getScopeLocation(stack), scopeScale);
            } else {
                scopeScale = 0.5f;
                PostChain postEffect = Minecraft.m_91087_().f_91063_.f_109050_;
                if (postEffect != null && postEffect.m_110022_().equals("mekanism_weaponry:shaders/post/scope_blur.json")) {
                    Minecraft.m_91087_().f_91063_.m_109086_();
                }
            }
        }
    }

    private static ResourceLocation getScopeLocation(ItemStack stack) {
        GunItem gun = (GunItem)stack.m_41720_();
        ItemStack paintItem = gun.getAddon(stack, 1);
        int index = 0;
        if (paintItem.m_41619_()) {
            index = 3;
        }
        if (paintItem.m_150930_((Item)ItemRegistry.ALIEN_PAINT_BUCKET.get())) {
            index = 2;
        }
        if (paintItem.m_150930_((Item)ItemRegistry.COTTON_CANDY_PAINT_BUCKET.get())) {
            index = 0;
        }
        if (paintItem.m_150930_((Item)ItemRegistry.EVA_PAINT_BUCKET.get())) {
            index = 0;
        }
        if (paintItem.m_150930_((Item)ItemRegistry.BUMBLEBEE_PAINT_BUCKET.get())) {
            index = 0;
        }
        if (paintItem.m_150930_((Item)ItemRegistry.CRIMSON_PAINT_BUCKET.get())) {
            index = 1;
        }
        return new ResourceLocation("mekanism_weaponry", String.format("textures/misc/scope_overlay_%d.png", index));
    }

    private static void renderScopeOverlay(GuiGraphics guiGraphics, ResourceLocation scopeResource, float scopeScale) {
        float f = Math.min(guiGraphics.m_280182_(), guiGraphics.m_280206_());
        float f1 = Math.min((float)guiGraphics.m_280182_() / f, (float)guiGraphics.m_280206_() / f) * scopeScale;
        int i = Mth.m_14143_((float)(f * f1));
        int j = Mth.m_14143_((float)(f * f1));
        int k = (guiGraphics.m_280182_() - i) / 2;
        int l = (guiGraphics.m_280206_() - j) / 2;
        RenderSystem.enableBlend();
        guiGraphics.m_280398_(scopeResource, k, l, -90, 0.0f, 0.0f, i, j, i, j);
        RenderSystem.disableBlend();
        Minecraft.m_91087_().f_91063_.m_109128_(new ResourceLocation("mekanism_weaponry", "shaders/post/scope_blur.json"));
    }

    public static void computeFov(ComputeFovModifierEvent event) {
        GunItem gunItem;
        ItemStack stack;
        Item item;
        LocalPlayer player;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91066_.m_92176_().m_90612_() && (player = minecraft.f_91074_) != null && (item = (stack = player.m_21120_(InteractionHand.MAIN_HAND)).m_41720_()) instanceof GunItem && (gunItem = (GunItem)item).isScoping(stack)) {
            event.setNewFovModifier(0.2f);
        }
    }

    @SubscribeEvent
    public static void registerPaintColors(RegisterColorHandlersEvent.Item event) {
        ItemRegistry.ITEMS.getEntries().forEach(itemDeferredHolder -> {
            Object patt10826$temp = itemDeferredHolder.get();
            if (patt10826$temp instanceof PaintBucketItem) {
                PaintBucketItem item = (PaintBucketItem)((Object)((Object)patt10826$temp));
                event.register((stack, tintIndex) -> item.getColor(tintIndex), new ItemLike[]{item});
            }
        });
    }

    static {
        RELOAD_MAPPING = new KeyMapping("key.mekanism_weaponry.reload", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 82, "key.categories.mekanism_weaponry");
    }
}

