/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.common.block_entity;

import java.util.List;
import java.util.Objects;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.upgrade.IUpgradeData;
import net.minecraft.nbt.CompoundTag;

public final class LaserTurretUpgradeData
implements IUpgradeData {
    private final boolean targetsHostile;
    private final boolean targetsPassive;
    private final boolean targetsPlayers;
    private final boolean targetsTrusted;
    private final CompoundTag components;

    public LaserTurretUpgradeData(boolean targetsHostile, boolean targetsPassive, boolean targetsPlayers, boolean targetsTrusted, List<ITileComponent> components) {
        this.targetsHostile = targetsHostile;
        this.targetsPassive = targetsPassive;
        this.targetsPlayers = targetsPlayers;
        this.targetsTrusted = targetsTrusted;
        this.components = new CompoundTag();
        for (ITileComponent component : components) {
            component.write(this.components);
        }
    }

    public boolean targetsHostile() {
        return this.targetsHostile;
    }

    public boolean targetsPassive() {
        return this.targetsPassive;
    }

    public boolean targetsPlayers() {
        return this.targetsPlayers;
    }

    public boolean targetsTrusted() {
        return this.targetsTrusted;
    }

    public CompoundTag components() {
        return this.components;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LaserTurretUpgradeData that = (LaserTurretUpgradeData)obj;
        return this.targetsHostile == that.targetsHostile && this.targetsPassive == that.targetsPassive && this.targetsPlayers == that.targetsPlayers && this.targetsTrusted == that.targetsTrusted && Objects.equals(this.components, that.components);
    }

    public int hashCode() {
        return Objects.hash(this.targetsHostile, this.targetsPassive, this.targetsPlayers, this.targetsTrusted, this.components);
    }

    public String toString() {
        return "LaserTurretUpgradeData[targetsHostile=" + this.targetsHostile + ", targetsPassive=" + this.targetsPassive + ", targetsPlayers=" + this.targetsPlayers + ", targetsTrusted=" + this.targetsTrusted + ", components=" + this.components + "]";
    }
}

