/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.client.gui;

import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretBlockEntity;
import com.github.x3r.mekanism_turrets.common.packet.MekanismTurretsPacketHandler;
import com.github.x3r.mekanism_turrets.common.packet.ModifyTurretTargetPacket;
import java.util.List;
import mekanism.api.math.FloatingLong;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.button.ToggleButton;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class LaserTurretScreen
extends GuiMekanismTile<LaserTurretBlockEntity, MekanismTileContainer<LaserTurretBlockEntity>> {
    private static final ResourceLocation TARGET_HOSTILE_OFF = new ResourceLocation("mekanism_turrets", "textures/gui/target_hostile_off.png");
    private static final ResourceLocation TARGET_HOSTILE_ON = new ResourceLocation("mekanism_turrets", "textures/gui/target_hostile_on.png");
    private static final ResourceLocation TARGET_PASSIVE_OFF = new ResourceLocation("mekanism_turrets", "textures/gui/target_passive_off.png");
    private static final ResourceLocation TARGET_PASSIVE_ON = new ResourceLocation("mekanism_turrets", "textures/gui/target_passive_on.png");
    private static final ResourceLocation TARGET_PLAYER_OFF = new ResourceLocation("mekanism_turrets", "textures/gui/target_players_off.png");
    private static final ResourceLocation TARGET_PLAYER_ON = new ResourceLocation("mekanism_turrets", "textures/gui/target_players_on.png");
    private static final ResourceLocation TARGET_TRUSTED_OFF = new ResourceLocation("mekanism_turrets", "textures/gui/target_trusted_off.png");
    private static final ResourceLocation TARGET_TRUSTED_ON = new ResourceLocation("mekanism_turrets", "textures/gui/target_trusted_on.png");

    public LaserTurretScreen(MekanismTileContainer<LaserTurretBlockEntity> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    protected void addGuiElements() {
        super.addGuiElements();
        ((GuiVerticalPowerBar)this.addRenderableWidget((GuiElement)new GuiVerticalPowerBar((IGuiWrapper)this, ((LaserTurretBlockEntity)this.tile).getEnergyContainer(), 164, 15))).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY, () -> {
            MachineEnergyContainer<LaserTurretBlockEntity> energyContainer = ((LaserTurretBlockEntity)this.tile).getEnergyContainer();
            return energyContainer.getEnergyPerTick().greaterThan(energyContainer.getEnergy());
        });
        FloatingLong energyPerTick = ((LaserTurretBlockEntity)this.tile).getEnergyContainer().getEnergyPerTick();
        this.addRenderableWidget((GuiElement)new GuiEnergyTab((IGuiWrapper)this, () -> List.of(Component.m_237115_((String)"gui.turret.energy_per_shot").m_7220_(EnergyDisplay.of((FloatingLong)energyPerTick).getTextComponent()), MekanismLang.NEEDED.translate(new Object[]{EnergyDisplay.of((FloatingLong)energyPerTick.subtract(((LaserTurretBlockEntity)this.tile).getEnergyContainer().getEnergy()))}))));
        int i = 25;
        this.addRenderableWidget((GuiElement)new ToggleButton((IGuiWrapper)this, 40, 33, 20, 20, TARGET_HOSTILE_OFF, TARGET_HOSTILE_ON, ((LaserTurretBlockEntity)this.tile)::targetsHostile, () -> MekanismTurretsPacketHandler.sendToServer(new ModifyTurretTargetPacket(((LaserTurretBlockEntity)this.tile).m_58899_(), 0, !((LaserTurretBlockEntity)this.tile).targetsHostile())), (element, guiGraphics, mouseX, mouseY) -> guiGraphics.m_280666_(this.f_96547_, List.of(Component.m_237115_((String)"gui.turret.target_hostile")), mouseX, mouseY)));
        this.addRenderableWidget((GuiElement)new ToggleButton((IGuiWrapper)this, 40 + i, 33, 20, 20, TARGET_PASSIVE_OFF, TARGET_PASSIVE_ON, ((LaserTurretBlockEntity)this.tile)::targetsPassive, () -> MekanismTurretsPacketHandler.sendToServer(new ModifyTurretTargetPacket(((LaserTurretBlockEntity)this.tile).m_58899_(), 1, !((LaserTurretBlockEntity)this.tile).targetsPassive())), (element, guiGraphics, mouseX, mouseY) -> guiGraphics.m_280666_(this.f_96547_, List.of(Component.m_237115_((String)"gui.turret.target_passive")), mouseX, mouseY)));
        this.addRenderableWidget((GuiElement)new ToggleButton((IGuiWrapper)this, 40 + 2 * i, 33, 20, 20, TARGET_PLAYER_OFF, TARGET_PLAYER_ON, ((LaserTurretBlockEntity)this.tile)::targetsPlayers, () -> MekanismTurretsPacketHandler.sendToServer(new ModifyTurretTargetPacket(((LaserTurretBlockEntity)this.tile).m_58899_(), 2, !((LaserTurretBlockEntity)this.tile).targetsPlayers())), (element, guiGraphics, mouseX, mouseY) -> guiGraphics.m_280666_(this.f_96547_, List.of(Component.m_237115_((String)"gui.turret.target_players")), mouseX, mouseY)));
        this.addRenderableWidget((GuiElement)new ToggleButton((IGuiWrapper)this, 40 + 3 * i, 33, 20, 20, TARGET_TRUSTED_OFF, TARGET_TRUSTED_ON, ((LaserTurretBlockEntity)this.tile)::targetsTrusted, () -> MekanismTurretsPacketHandler.sendToServer(new ModifyTurretTargetPacket(((LaserTurretBlockEntity)this.tile).m_58899_(), 3, !((LaserTurretBlockEntity)this.tile).targetsTrusted())), (element, guiGraphics, mouseX, mouseY) -> guiGraphics.m_280666_(this.f_96547_, List.of(Component.m_237115_((String)"gui.turret.target_trusted")), mouseX, mouseY)){

            public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                if (((LaserTurretBlockEntity)LaserTurretScreen.this.tile).targetsPlayers()) {
                    super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
                }
            }

            public boolean m_7972_(int button) {
                return ((LaserTurretBlockEntity)LaserTurretScreen.this.tile).targetsPlayers() && super.m_7972_(button);
            }

            public void renderToolTip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
                if (((LaserTurretBlockEntity)LaserTurretScreen.this.tile).targetsPlayers()) {
                    super.renderToolTip(guiGraphics, mouseX, mouseY);
                }
            }
        });
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

