/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.mekanism_lasers_old.common.block_entity;

import com.folumo.mekanism_lasers_old.Config;
import com.folumo.mekanism_lasers_old.common.registry.BlockRegistry;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.LaserEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.laser.TileEntityLaserReceptor;
import mekanism.common.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.jetbrains.annotations.NotNull;

public class OreGeneratorBlockEntity
extends TileEntityLaserReceptor {
    private int coolDown = 0;
    public static FloatingLong energyCap = FloatingLong.createConst((long)64000000L);
    private LaserEnergyContainer energyContainer;
    public static long usage = (Long)Config.oreGeneratorFabricationCost.get();
    public static int cooldown = (Integer)Config.oreGeneratorCooldown.get();
    public static int numberOfOres = (Integer)Config.oreGeneratorNumberOfOres.get();

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((OreGeneratorBlockEntity)this).getDirection());
        for (int slotX = 0; slotX < 5; ++slotX) {
            for (int slotY = 0; slotY < 3; ++slotY) {
                OutputInventorySlot slot = OutputInventorySlot.at((IContentsListener)listener, (int)(8 + slotX * 18), (int)(16 + slotY * 18));
                builder.addSlot((IInventorySlot)slot);
                slot.setSlotType(ContainerSlotType.NORMAL);
            }
        }
        return builder.build();
    }

    public OreGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockRegistry.ORE_GENERATOR, pos, state);
    }

    public static FloatingLong getUsage() {
        return FloatingLong.createConst((long)usage);
    }

    public static FloatingLong getEnergyCap() {
        return energyCap;
    }

    public void receiveLaserEnergy(@NotNull FloatingLong energy) {
        this.energyContainer.insert(energy, Action.EXECUTE, AutomationType.INTERNAL);
    }

    @NotNull
    public Component m_7755_() {
        return Component.m_237113_((String)"Ore Generator");
    }

    protected void addInitialEnergyContainers(EnergyContainerHelper builder, IContentsListener listener) {
        this.energyContainer = LaserEnergyContainer.create((Predicate)BasicEnergyContainer.notExternal, (Predicate)BasicEnergyContainer.internalOnly, (TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
    }

    public LaserEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    protected void onUpdateServer() {
        if (this.coolDown == 0) {
            this.coolDown = 20 * cooldown;
            if (this.energyContainer.getEnergy().greaterOrEqual(OreGeneratorBlockEntity.getUsage())) {
                this.generateOres();
            }
        } else {
            --this.coolDown;
        }
    }

    private void generateOre1() {
        List inventorySlots = this.getInventorySlots(null);
        ItemStack drop = InventoryUtils.insertItem((List)inventorySlots, (ItemStack)OreGeneratorBlockEntity.getRandomDrop(), (Action)Action.EXECUTE, (AutomationType)AutomationType.INTERNAL);
        if (drop.m_41619_()) {
            this.energyContainer.extract(OreGeneratorBlockEntity.getUsage(), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    private void generateOres() {
        ItemStack drop;
        List inventorySlots = this.getInventorySlots(null);
        FloatingLong energyPerOre = OreGeneratorBlockEntity.getUsage().divide((long)numberOfOres);
        for (int i = 0; i < numberOfOres && (drop = InventoryUtils.insertItem((List)inventorySlots, (ItemStack)OreGeneratorBlockEntity.getRandomDrop(), (Action)Action.EXECUTE, (AutomationType)AutomationType.INTERNAL)).m_41619_(); ++i) {
            this.energyContainer.extract(energyPerOre, Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    private static ItemStack getRandomDrop() {
        TagKey blockTag = BlockTags.create((ResourceLocation)new ResourceLocation("forge", "ores"));
        ITag oreTag = Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(blockTag);
        RandomSource randomSource = RandomSource.m_216327_();
        return new ItemStack((ItemLike)((Block)oreTag.getRandomElement(randomSource).get()).m_5456_());
    }
}

