/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.tile.machine;

import com.jerry.mekanism_extras.api.ExtraUpgrade;
import com.jerry.mekanism_extras.common.config.LoadConfig;
import com.jerry.mekanism_extras.common.registry.ExtraBlock;
import com.jerry.mekanism_extras.common.registry.ExtraFluids;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableFluidStack;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.UpgradeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityAdvancedElectricPump
extends TileEntityMekanism
implements IConfigurable {
    private static final int BASE_TICKS_REQUIRED = 19;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getFluid", "getFluidCapacity", "getFluidNeeded", "getFluidFilledPercentage"}, docPlaceholder="buffer tank")
    public BasicFluidTank fluidTank;
    @NotNull
    private FluidStack activeType = FluidStack.EMPTY;
    public int ticksRequired = 19;
    public int operatingTicks;
    private boolean usedEnergy = false;
    private final Set<BlockPos> recurringNodes = new ObjectOpenHashSet();
    private MachineEnergyContainer<TileEntityAdvancedElectricPump> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input slot")
    FluidInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    OutputInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntityAdvancedElectricPump(BlockPos pos, BlockState state) {
        super(ExtraBlock.ADVANCED_ELECTRIC_PUMP, pos, state);
        this.addCapabilityResolver((ICapabilityResolver)BasicCapabilityResolver.constant((Capability)Capabilities.CONFIGURABLE, (Object)((Object)this)));
        this.addCapabilityResolver((ICapabilityResolver)BasicCapabilityResolver.constant((Capability)Capabilities.CONFIG_CARD, (Object)((Object)this)));
    }

    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSide(() -> ((TileEntityAdvancedElectricPump)this).getDirection());
        this.fluidTank = BasicFluidTank.output((int)10000000, (IContentsListener)listener);
        builder.addTank((IExtendedFluidTank)this.fluidTank, new RelativeSide[]{RelativeSide.TOP});
        return builder.build();
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(() -> ((TileEntityAdvancedElectricPump)this).getDirection());
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer, new RelativeSide[]{RelativeSide.BACK});
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityAdvancedElectricPump)this).getDirection());
        this.inputSlot = FluidInventorySlot.drain((IExtendedFluidTank)this.fluidTank, (IContentsListener)listener, (int)28, (int)20);
        builder.addSlot((IInventorySlot)this.inputSlot, new RelativeSide[]{RelativeSide.TOP});
        this.outputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)28, (int)51);
        builder.addSlot((IInventorySlot)this.outputSlot, new RelativeSide[]{RelativeSide.BOTTOM});
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityAdvancedElectricPump)this).m_58904_(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.BACK});
        return builder.build();
    }

    protected void onUpdateServer() {
        FloatingLong energyPerTick;
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.inputSlot.drainTank((IInventorySlot)this.outputSlot);
        FloatingLong clientEnergyUsed = FloatingLong.ZERO;
        if (MekanismUtils.canFunction((TileEntityMekanism)this) && (this.fluidTank.isEmpty() || this.estimateIncrementAmount() <= this.fluidTank.getNeeded()) && this.energyContainer.extract(energyPerTick = this.energyContainer.getEnergyPerTick(), Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
            if (!this.activeType.isEmpty()) {
                clientEnergyUsed = this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
            }
            ++this.operatingTicks;
            if (this.operatingTicks >= this.ticksRequired) {
                this.operatingTicks = 0;
                if (this.suck()) {
                    if (clientEnergyUsed.isZero()) {
                        clientEnergyUsed = this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                    }
                } else {
                    this.reset();
                }
            }
        }
        boolean bl = this.usedEnergy = !clientEnergyUsed.isZero();
        if (!this.fluidTank.isEmpty()) {
            FluidUtils.emit(Collections.singleton(Direction.UP), (IExtendedFluidTank)this.fluidTank, (BlockEntity)this, (int)(1024 * (1 + this.upgradeComponent.getUpgrades(Upgrade.SPEED))));
        }
    }

    public int estimateIncrementAmount() {
        return this.fluidTank.getFluid().getFluid() == MekanismFluids.HEAVY_WATER.getFluid() ? LoadConfig.extraConfig.pumpHeavyWaterAmount.get() : 1000;
    }

    private boolean suck() {
        boolean hasFilter = this.upgradeComponent.isUpgradeInstalled(Upgrade.FILTER);
        if (this.suck(this.f_58858_.m_121945_(Direction.DOWN), hasFilter, true)) {
            return true;
        }
        ArrayList<BlockPos> tempPumpList = new ArrayList<BlockPos>(this.recurringNodes);
        Collections.shuffle(tempPumpList);
        for (BlockPos tempPumpPos : tempPumpList) {
            if (this.suck(tempPumpPos, hasFilter, false)) {
                return true;
            }
            for (Direction orientation : EnumUtils.DIRECTIONS) {
                BlockPos side = tempPumpPos.m_121945_(orientation);
                if (!(WorldUtils.distanceBetween((BlockPos)this.f_58858_, (BlockPos)side) <= (double)MekanismConfig.general.maxPumpRange.get()) || !this.suck(side, hasFilter, true)) continue;
                return true;
            }
            this.recurringNodes.remove(tempPumpPos);
        }
        return false;
    }

    private boolean suck(BlockPos pos, boolean hasFilter, boolean addRecurring) {
        BlockState blockState;
        FluidState fluidState;
        Optional state = WorldUtils.getBlockState((BlockGetter)this.f_58857_, (BlockPos)pos);
        if (state.isPresent() && !(fluidState = (blockState = (BlockState)state.get()).m_60819_()).m_76178_() && fluidState.m_76170_()) {
            Block block = blockState.m_60734_();
            if (block instanceof IFluidBlock) {
                IFluidBlock fluidBlock = (IFluidBlock)block;
                if (this.validFluid(fluidBlock.drain(this.f_58857_, pos, IFluidHandler.FluidAction.SIMULATE))) {
                    this.suck(fluidBlock.drain(this.f_58857_, pos, IFluidHandler.FluidAction.EXECUTE), pos, addRecurring);
                    return true;
                }
            } else if (block instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)block;
                Fluid sourceFluid = fluidState.m_76152_();
                FluidStack fluidStack = this.getOutput(sourceFluid, hasFilter);
                if (this.validFluid(fluidStack)) {
                    if (sourceFluid != Fluids.f_76193_ || MekanismConfig.general.pumpWaterSources.get()) {
                        BucketItem bucket;
                        ItemStack pickedUpStack = bucketPickup.m_142598_((LevelAccessor)this.f_58857_, pos, blockState);
                        if (pickedUpStack.m_41619_()) {
                            return false;
                        }
                        Item item = pickedUpStack.m_41720_();
                        if (item instanceof BucketItem && !this.validFluid(fluidStack = this.getOutput(sourceFluid = (bucket = (BucketItem)item).getFluid(), hasFilter))) {
                            Mekanism.logger.warn("Fluid removed without successfully picking up. Fluid {} at {} in {} was valid, but after picking up was {}.", new Object[]{fluidState.m_76152_(), pos, this.f_58857_, sourceFluid});
                            return false;
                        }
                    }
                    this.suck(fluidStack, pos, addRecurring);
                    return true;
                }
            }
        }
        return false;
    }

    private FluidStack getOutput(Fluid sourceFluid, boolean hasFilter) {
        boolean hasMembrane = this.upgradeComponent.isUpgradeInstalled(ExtraUpgrade.IONIC_MEMBRANE);
        if (sourceFluid == Fluids.f_76193_) {
            if (hasFilter) {
                return MekanismFluids.HEAVY_WATER.getFluidStack(LoadConfig.extraConfig.pumpHeavyWaterAmount.get());
            }
            return MekanismConfig.general.pumpWaterSources.get() ? new FluidStack(sourceFluid, 1000) : new FluidStack(sourceFluid, 100000);
        }
        if (sourceFluid == ExtraFluids.SILICON_TETRAFLUORIDE.getFluid() && hasMembrane) {
            return new FluidStack(ExtraFluids.RICH_SILICON_LIQUID_FUEL.getFluid(), 1000);
        }
        if (sourceFluid == MekanismFluids.URANIUM_HEXAFLUORIDE.getFluid() && hasMembrane) {
            return new FluidStack(ExtraFluids.RICH_URANIUM_LIQUID_FUEL.getFluid(), 1000);
        }
        return new FluidStack(sourceFluid, 1000);
    }

    private void suck(@NotNull FluidStack fluidStack, BlockPos pos, boolean addRecurring) {
        this.activeType = new FluidStack(fluidStack, 1);
        if (addRecurring) {
            this.recurringNodes.add(pos);
        }
        this.fluidTank.insert(fluidStack, Action.EXECUTE, AutomationType.INTERNAL);
        this.f_58857_.m_142346_(null, GameEvent.f_157816_, pos);
    }

    private boolean validFluid(@NotNull FluidStack fluidStack) {
        if (!fluidStack.isEmpty() && (this.activeType.isEmpty() || this.activeType.isFluidEqual(fluidStack))) {
            if (this.fluidTank.isEmpty()) {
                return true;
            }
            if (this.fluidTank.isFluidEqual(fluidStack)) {
                return fluidStack.getAmount() <= this.fluidTank.getNeeded();
            }
        }
        return false;
    }

    public void reset() {
        this.activeType = FluidStack.EMPTY;
        this.recurringNodes.clear();
    }

    public void m_183515_(@NotNull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        nbtTags.m_128405_("progress", this.operatingTicks);
        if (!this.activeType.isEmpty()) {
            nbtTags.m_128365_("fluid", (Tag)this.activeType.writeToNBT(new CompoundTag()));
        }
        if (!this.recurringNodes.isEmpty()) {
            ListTag recurringList = new ListTag();
            for (BlockPos nodePos : this.recurringNodes) {
                recurringList.add((Object)NbtUtils.m_129224_((BlockPos)nodePos));
            }
            nbtTags.m_128365_("recurringNodes", (Tag)recurringList);
        }
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.operatingTicks = nbt.m_128451_("progress");
        NBTUtils.setFluidStackIfPresent((CompoundTag)nbt, (String)"fluid", fluid -> {
            this.activeType = fluid;
        });
        if (nbt.m_128425_("recurringNodes", 9)) {
            ListTag tagList = nbt.m_128437_("recurringNodes", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                this.recurringNodes.add(NbtUtils.m_129239_((CompoundTag)tagList.m_128728_(i)));
            }
        }
    }

    public InteractionResult onSneakRightClick(Player player) {
        this.reset();
        player.m_5661_((Component)MekanismLang.PUMP_RESET.translate(new Object[0]), true);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    public boolean canPulse() {
        return true;
    }

    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks((IUpgradeTile)this, (int)19);
        }
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.fluidTank.getFluidAmount(), (long)this.fluidTank.getCapacity());
    }

    protected boolean makesComparatorDirty(@Nullable SubstanceType type) {
        return type == SubstanceType.FLUID;
    }

    @NotNull
    public List<Component> getInfo(@NotNull Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo((IUpgradeTile)this, (Upgrade)upgrade);
    }

    public MachineEnergyContainer<TileEntityAdvancedElectricPump> getEnergyContainer() {
        return this.energyContainer;
    }

    public boolean usedEnergy() {
        return this.usedEnergy;
    }

    @NotNull
    public FluidStack getActiveType() {
        return this.activeType;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableBoolean.create(this::usedEnergy, value -> {
            this.usedEnergy = value;
        }));
        container.track((ISyncableData)SyncableFluidStack.create(this::getActiveType, value -> {
            this.activeType = value;
        }));
    }

    @ComputerMethod(nameOverride="reset", requiresPublicSecurity=true)
    void resetPump() throws ComputerException {
        this.validateSecurityIsPublic();
        this.reset();
    }
}

