/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.inventory.slot;

import com.jerry.mekanism_extras.common.item.block.ExtraItemBlockBin;
import com.jerry.mekanism_extras.common.tier.BTier;
import java.util.Objects;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraBinInventorySlot
extends BasicInventorySlot {
    private static final Predicate<@NotNull ItemStack> validator = stack -> !(stack.m_41720_() instanceof ExtraItemBlockBin) && !(stack.m_41720_() instanceof ItemBlockBin);
    private final boolean isCreative;
    private ItemStack lockStack = ItemStack.f_41583_;

    public static ExtraBinInventorySlot create(@Nullable IContentsListener listener, BTier tier) {
        Objects.requireNonNull(tier, "Bin tier cannot be null");
        return new ExtraBinInventorySlot(listener, tier);
    }

    private ExtraBinInventorySlot(@Nullable IContentsListener listener, BTier tier) {
        super(tier.getStorage(), alwaysTrueBi, alwaysTrueBi, validator, listener, 0, 0);
        this.isCreative = false;
        this.obeyStackLimit = false;
    }

    @NotNull
    public ItemStack insertItem(@NotNull ItemStack stack, @NotNull Action action, @NotNull AutomationType automationType) {
        if (this.isEmpty()) {
            if (this.isLocked() && !ItemHandlerHelper.canItemStacksStack((ItemStack)this.lockStack, (ItemStack)stack)) {
                return stack;
            }
            if (this.isCreative && action.execute() && automationType != AutomationType.EXTERNAL) {
                ItemStack simulatedRemainder = super.insertItem(stack, Action.SIMULATE, automationType);
                if (simulatedRemainder.m_41619_()) {
                    this.setStackUnchecked(stack.m_255036_(this.getLimit(stack)));
                }
                return simulatedRemainder;
            }
        }
        return super.insertItem(stack, action.combine(!this.isCreative), automationType);
    }

    @NotNull
    public ItemStack extractItem(int amount, Action action, @NotNull AutomationType automationType) {
        return super.extractItem(amount, action.combine(!this.isCreative), automationType);
    }

    public int setStackSize(int amount, Action action) {
        return super.setStackSize(amount, action.combine(!this.isCreative));
    }

    @Nullable
    public InventoryContainerSlot createContainerSlot() {
        return null;
    }

    public ItemStack getBottomStack() {
        if (this.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return this.current.m_255036_(Math.min(this.getCount(), this.current.m_41741_()));
    }

    public boolean setLocked(boolean lock) {
        if (this.isCreative || this.isLocked() == lock || lock && this.isEmpty()) {
            return false;
        }
        this.lockStack = lock ? this.current.m_255036_(1) : ItemStack.f_41583_;
        return true;
    }

    public void setLockStack(@NotNull ItemStack stack) {
        this.lockStack = stack.m_255036_(1);
    }

    public boolean isLocked() {
        return !this.lockStack.m_41619_();
    }

    public ItemStack getRenderStack() {
        return this.isLocked() ? this.getLockStack() : this.getStack();
    }

    public ItemStack getLockStack() {
        return this.lockStack;
    }

    @NotNull
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        if (this.isLocked()) {
            nbt.m_128365_("lockStack", (Tag)this.lockStack.serializeNBT());
        }
        return nbt;
    }

    public void deserializeNBT(@NotNull CompoundTag nbt) {
        NBTUtils.setItemStackOrEmpty((CompoundTag)nbt, (String)"lockStack", s -> {
            this.lockStack = s;
        });
        super.deserializeNBT(nbt);
    }
}

