/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.content.network.transmitter;

import com.jerry.mekanism_extras.common.content.network.transmitter.IExtraUpgradeableTransmitter;
import com.jerry.mekanism_extras.common.tier.transmitter.PTier;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.content.network.transmitter.MechanicalPipe;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.MechanicalPipeUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraMechanicalPipe
extends MechanicalPipe
implements IExtraUpgradeableTransmitter<MechanicalPipeUpgradeData> {
    public ExtraMechanicalPipe(IBlockProvider blockProvider, TileEntityTransmitter tile) {
        super(blockProvider, tile);
    }

    public void pullFromAcceptors() {
        Set connections = this.getConnections(ConnectionType.PULL);
        if (!connections.isEmpty()) {
            for (IFluidHandler connectedAcceptor : this.getAcceptorCache().getConnectedAcceptors(connections)) {
                FluidStack bufferWithFallback = this.getBufferWithFallback();
                FluidStack received = bufferWithFallback.isEmpty() ? connectedAcceptor.drain(this.getAvailablePull(), IFluidHandler.FluidAction.SIMULATE) : connectedAcceptor.drain(new FluidStack(bufferWithFallback, this.getAvailablePull()), IFluidHandler.FluidAction.SIMULATE);
                if (received.isEmpty() || !this.takeFluid(received, Action.SIMULATE).isEmpty()) continue;
                this.takeFluid(connectedAcceptor.drain(received, IFluidHandler.FluidAction.EXECUTE), Action.EXECUTE);
            }
        }
    }

    private int getAvailablePull() {
        return this.hasTransmitterNetwork() ? Math.min(PTier.getPipePullAmount(this.tier), ((FluidNetwork)this.getTransmitterNetwork()).fluidTank.getNeeded()) : Math.min(PTier.getPipePullAmount(this.tier), this.buffer.getNeeded());
    }

    public long getCapacity() {
        return PTier.getPipeCapacity(this.tier);
    }

    @Override
    @Nullable
    public MechanicalPipeUpgradeData getUpgradeData() {
        return super.getUpgradeData();
    }

    @Override
    public boolean dataTypeMatches(@NotNull TransmitterUpgradeData data) {
        return super.dataTypeMatches(data);
    }

    @Override
    public void parseUpgradeData(@NotNull MechanicalPipeUpgradeData data) {
        super.parseUpgradeData(data);
    }
}

