/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.content.matrix;

import com.jerry.mekanism_extras.common.content.matrix.ExtraMatrixEnergyContainer;
import com.jerry.mekanism_extras.common.tile.multiblock.ExtraTileEntityInductionCell;
import com.jerry.mekanism_extras.common.tile.multiblock.ExtraTileEntityInductionProvider;
import com.jerry.mekanism_extras.common.tile.multiblock.TileEntityReinforcedInductionCasing;
import mekanism.api.IContentsListener;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ExtraMatrixMultiblockData
extends MultiblockData {
    public static final String STATS_TAB = "stats1";
    @NotNull
    private final ExtraMatrixEnergyContainer energyContainer;
    @ContainerSync(getter="getLastOutput")
    private FloatingLong clientLastOutput = FloatingLong.ZERO;
    @ContainerSync(getter="getLastInput")
    private FloatingLong clientLastInput = FloatingLong.ZERO;
    @ContainerSync(getter="getEnergy")
    private FloatingLong clientEnergy = FloatingLong.ZERO;
    @ContainerSync(tags={"stats1"}, getter="getTransferCap")
    private FloatingLong clientMaxTransfer = FloatingLong.ZERO;
    @ContainerSync(getter="getStorageCap")
    private FloatingLong clientMaxEnergy = FloatingLong.ZERO;
    @ContainerSync(tags={"stats1"}, getter="getProviderCount")
    private int clientProviders;
    @ContainerSync(tags={"stats1"}, getter="getCellCount")
    private int clientCells;
    @NotNull
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input slot")
    final EnergyInventorySlot energyInputSlot;
    @NotNull
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    final EnergyInventorySlot energyOutputSlot;

    public ExtraMatrixMultiblockData(TileEntityReinforcedInductionCasing tile) {
        super((BlockEntity)tile);
        this.energyContainer = new ExtraMatrixEnergyContainer(this);
        this.energyContainers.add(this.energyContainer);
        this.energyInputSlot = EnergyInventorySlot.drain((IEnergyContainer)this.energyContainer, (IContentsListener)this, (int)146, (int)21);
        this.inventorySlots.add(this.energyInputSlot);
        this.energyOutputSlot = EnergyInventorySlot.fillOrConvert((IEnergyContainer)this.energyContainer, () -> ((TileEntityReinforcedInductionCasing)tile).m_58904_(), (IContentsListener)this, (int)146, (int)51);
        this.inventorySlots.add(this.energyOutputSlot);
        this.energyInputSlot.setSlotOverlay(SlotOverlay.PLUS);
        this.energyOutputSlot.setSlotOverlay(SlotOverlay.MINUS);
    }

    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((FloatingLong)this.getEnergy(), (FloatingLong)this.getStorageCap());
    }

    protected boolean shouldCap(MultiblockCache.CacheSubstance<?, ?> type) {
        return type != MultiblockCache.CacheSubstance.ENERGY;
    }

    public void addCell(ExtraTileEntityInductionCell cell) {
        this.energyContainer.addCell(cell.m_58899_(), cell);
    }

    public void addProvider(ExtraTileEntityInductionProvider provider) {
        this.energyContainer.addProvider(provider.m_58899_(), provider);
    }

    @NotNull
    public ExtraMatrixEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    public FloatingLong getEnergy() {
        return this.isRemote() ? this.clientEnergy : this.energyContainer.getEnergy();
    }

    public boolean tick(Level world) {
        boolean ret = super.tick(world);
        this.energyContainer.tick();
        this.energyInputSlot.drainContainer();
        this.energyOutputSlot.fillContainerOrConvert();
        if (!this.getLastInput().isZero() || !this.getLastOutput().isZero()) {
            this.markDirtyComparator(world);
        }
        return ret;
    }

    public void remove(Level world) {
        this.energyContainer.invalidate();
        super.remove(world);
    }

    public FloatingLong getStorageCap() {
        return this.isRemote() ? this.clientMaxEnergy : this.energyContainer.getMaxEnergy();
    }

    @ComputerMethod
    public FloatingLong getTransferCap() {
        return this.isRemote() ? this.clientMaxTransfer : this.energyContainer.getMaxTransfer();
    }

    @ComputerMethod
    public FloatingLong getLastInput() {
        return this.isRemote() ? this.clientLastInput : this.energyContainer.getLastInput();
    }

    @ComputerMethod
    public FloatingLong getLastOutput() {
        return this.isRemote() ? this.clientLastOutput : this.energyContainer.getLastOutput();
    }

    @ComputerMethod(nameOverride="getInstalledCells")
    public int getCellCount() {
        return this.isRemote() ? this.clientCells : this.energyContainer.getCells();
    }

    @ComputerMethod(nameOverride="getInstalledProviders")
    public int getProviderCount() {
        return this.isRemote() ? this.clientProviders : this.energyContainer.getProviders();
    }
}

