/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.capabilities.chemical;

import com.jerry.mekanism_extras.common.tier.CTTier;
import java.util.Objects;
import java.util.function.LongSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import org.jetbrains.annotations.Nullable;

public abstract class ExtraChemicalTankChemicalTank<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends BasicChemicalTank<CHEMICAL, STACK> {
    private final boolean isCreative;
    private final LongSupplier rate = tier::getOutput;

    public static MergedChemicalTank create(CTTier tier, @Nullable IContentsListener listener) {
        Objects.requireNonNull(tier, "Chemical tank tier cannot be null");
        return MergedChemicalTank.create((IGasTank)new GasTankChemicalTank(tier, listener), (IInfusionTank)new InfusionTankChemicalTank(tier, listener), (IPigmentTank)new PigmentTankChemicalTank(tier, listener), (ISlurryTank)new SlurryTankChemicalTank(tier, listener));
    }

    private ExtraChemicalTankChemicalTank(CTTier tier, ChemicalTankBuilder<CHEMICAL, STACK, ?> tankBuilder, @Nullable IContentsListener listener) {
        super(tier.getStorage(), tankBuilder.alwaysTrueBi, tankBuilder.alwaysTrueBi, tankBuilder.alwaysTrue, null, listener);
        this.isCreative = false;
    }

    protected long getRate(@Nullable AutomationType automationType) {
        return automationType == AutomationType.INTERNAL ? this.rate.getAsLong() : super.getRate(automationType);
    }

    public STACK insert(STACK stack, Action action, AutomationType automationType) {
        if (this.isCreative && this.isEmpty() && action.execute() && automationType != AutomationType.EXTERNAL) {
            ChemicalStack simulatedRemainder = super.insert(stack, Action.SIMULATE, automationType);
            if (simulatedRemainder.isEmpty()) {
                this.setStackUnchecked(this.createStack((ChemicalStack)stack, this.getCapacity()));
            }
            return (STACK)simulatedRemainder;
        }
        return (STACK)super.insert(stack, action.combine(!this.isCreative), automationType);
    }

    public STACK extract(long amount, Action action, AutomationType automationType) {
        return (STACK)super.extract(amount, action.combine(!this.isCreative), automationType);
    }

    public long setStackSize(long amount, Action action) {
        return super.setStackSize(amount, action.combine(!this.isCreative));
    }

    private static class GasTankChemicalTank
    extends ExtraChemicalTankChemicalTank<Gas, GasStack>
    implements IGasHandler,
    IGasTank {
        private GasTankChemicalTank(CTTier tier, @Nullable IContentsListener listener) {
            super(tier, ChemicalTankBuilder.GAS, listener);
        }
    }

    private static class InfusionTankChemicalTank
    extends ExtraChemicalTankChemicalTank<InfuseType, InfusionStack>
    implements IInfusionHandler,
    IInfusionTank {
        private InfusionTankChemicalTank(CTTier tier, @Nullable IContentsListener listener) {
            super(tier, ChemicalTankBuilder.INFUSION, listener);
        }
    }

    private static class PigmentTankChemicalTank
    extends ExtraChemicalTankChemicalTank<Pigment, PigmentStack>
    implements IPigmentHandler,
    IPigmentTank {
        private PigmentTankChemicalTank(CTTier tier, @Nullable IContentsListener listener) {
            super(tier, ChemicalTankBuilder.PIGMENT, listener);
        }
    }

    private static class SlurryTankChemicalTank
    extends ExtraChemicalTankChemicalTank<Slurry, SlurryStack>
    implements ISlurryHandler,
    ISlurryTank {
        private SlurryTankChemicalTank(CTTier tier, @Nullable IContentsListener listener) {
            super(tier, ChemicalTankBuilder.SLURRY, listener);
        }
    }
}

