/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras;

import com.jerry.generator_extras.common.ExtraGenLang;
import com.jerry.generator_extras.common.content.reactor.NaquadahReactorCache;
import com.jerry.generator_extras.common.content.reactor.NaquadahReactorMultiblockData;
import com.jerry.generator_extras.common.content.reactor.NaquadahReactorValidator;
import com.jerry.generator_extras.common.genregistry.ExtraGenBlocks;
import com.jerry.generator_extras.common.genregistry.ExtraGenContainerTypes;
import com.jerry.generator_extras.common.genregistry.ExtraGenFluids;
import com.jerry.generator_extras.common.genregistry.ExtraGenGases;
import com.jerry.generator_extras.common.genregistry.ExtraGenItem;
import com.jerry.generator_extras.common.genregistry.ExtraGenTileEntityTypes;
import com.jerry.mekanism_extras.client.events.ClientTick;
import com.jerry.mekanism_extras.common.ExtraLang;
import com.jerry.mekanism_extras.common.ExtraTag;
import com.jerry.mekanism_extras.common.command.ExtraBuilders;
import com.jerry.mekanism_extras.common.config.LoadConfig;
import com.jerry.mekanism_extras.common.content.matrix.ExtraMatrixMultiblockData;
import com.jerry.mekanism_extras.common.content.matrix.ExtraMatrixValidator;
import com.jerry.mekanism_extras.common.registry.ExtraBlock;
import com.jerry.mekanism_extras.common.registry.ExtraContainerTypes;
import com.jerry.mekanism_extras.common.registry.ExtraFluids;
import com.jerry.mekanism_extras.common.registry.ExtraGases;
import com.jerry.mekanism_extras.common.registry.ExtraInfuseTypes;
import com.jerry.mekanism_extras.common.registry.ExtraItem;
import com.jerry.mekanism_extras.common.registry.ExtraSlurries;
import com.jerry.mekanism_extras.common.registry.ExtraTab;
import com.jerry.mekanism_extras.common.registry.ExtraTileEntityTypes;
import com.jerry.mekanism_extras.integration.Addons;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import mekanism.api.text.ILangEntry;
import mekanism.common.command.CommandMek;
import mekanism.common.command.builders.BuildCommand;
import mekanism.common.command.builders.StructureBuilder;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockManager;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="mekanism_extras")
public class MekanismExtras {
    public static final String MODID = "mekanism_extras";
    public static final String MOD_NAME = "MekanismExtras";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MultiblockManager<ExtraMatrixMultiblockData> extraMatrixManager = new MultiblockManager("extraInductionMatrix", MultiblockCache::new, ExtraMatrixValidator::new);
    public static final MultiblockManager<NaquadahReactorMultiblockData> naquadahReactorManager = new MultiblockManager("naquadahReactor", NaquadahReactorCache::new, NaquadahReactorValidator::new);

    public MekanismExtras() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        LoadConfig.registerConfigs(ModLoadingContext.get());
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::setupBuiltinPack);
        ExtraBlock.register(modEventBus);
        ExtraItem.register(modEventBus);
        ExtraFluids.register(modEventBus);
        ExtraTab.register(modEventBus);
        ExtraTileEntityTypes.register(modEventBus);
        ExtraContainerTypes.register(modEventBus);
        ExtraGases.register(modEventBus);
        ExtraInfuseTypes.register(modEventBus);
        ExtraSlurries.register(modEventBus);
        MekanismExtras.conditionalRegistry(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)new ClientTick());
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    private void registerCommands(RegisterCommandsEvent event) {
        BuildCommand.register((String)"reinforced_matrix", (ILangEntry)ExtraLang.REINFORCED_MATRIX, (StructureBuilder)new ExtraBuilders.MatrixBuilder());
        if (Addons.MEKANISMGENERATORS.isLoaded()) {
            BuildCommand.register((String)"naquadah", (ILangEntry)ExtraGenLang.NAQUADAH_REACTOR, (StructureBuilder)new ExtraBuilders.NaquadahReactorBuilder());
        }
        event.getDispatcher().register(CommandMek.register());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(ExtraTag::init);
    }

    private static void conditionalRegistry(IEventBus modEventBus) {
        if (Addons.MEKANISMGENERATORS.isLoaded()) {
            ExtraGenItem.register(modEventBus);
            ExtraGenBlocks.register(modEventBus);
            ExtraGenFluids.register(modEventBus);
            ExtraGenContainerTypes.register(modEventBus);
            ExtraGenGases.register(modEventBus);
            ExtraGenTileEntityTypes.register(modEventBus);
        }
    }

    private void setupBuiltinPack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"stop_flashing"});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, resourcePath, true);
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.m_237115_((String)ExtraLang.STOP_FLASHING_DESC.getTranslationKey()), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES));
            event.addRepositorySource(source -> source.accept(Pack.m_245512_((String)"builtin/stop_flashing", (Component)Component.m_237115_((String)ExtraLang.STOP_FLASHING.getTranslationKey()), (boolean)false, string -> pack, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.getPackFormat(PackType.SERVER_DATA), metadata.getPackFormat(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_246902_(), pack.isHidden()), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_)));
        }
    }
}

