/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.generator_extras.common.network.to_server;

import com.jerry.generator_extras.common.tile.reactor.TileEntityNaquadahReactorController;
import com.jerry.generator_extras.common.tile.reactor.TileEntityNaquadahReactorLogicAdapter;
import mekanism.api.functions.TriConsumer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ExtraPacketGeneratorsGuiInteract
implements IMekanismPacket {
    private final ExtraGeneratorsGuiInteraction interaction;
    private final BlockPos tilePosition;
    private final double extra;

    public ExtraPacketGeneratorsGuiInteract(ExtraGeneratorsGuiInteraction interaction, BlockEntity tile, double extra) {
        this(interaction, tile.m_58899_(), extra);
    }

    public ExtraPacketGeneratorsGuiInteract(ExtraGeneratorsGuiInteraction interaction, BlockPos tilePosition, double extra) {
        this.interaction = interaction;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public void handle(NetworkEvent.Context context) {
        TileEntityMekanism tile;
        ServerPlayer player = context.getSender();
        if (player != null && (tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.m_9236_(), (BlockPos)this.tilePosition)) != null) {
            this.interaction.consume(tile, (Player)player, this.extra);
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.interaction);
        buffer.m_130064_(this.tilePosition);
        buffer.writeDouble(this.extra);
    }

    public static ExtraPacketGeneratorsGuiInteract decode(FriendlyByteBuf buffer) {
        return new ExtraPacketGeneratorsGuiInteract((ExtraGeneratorsGuiInteraction)buffer.m_130066_(ExtraGeneratorsGuiInteraction.class), buffer.m_130135_(), buffer.readDouble());
    }

    public static enum ExtraGeneratorsGuiInteraction {
        INJECTION_RATE((TriConsumer<TileEntityMekanism, Player, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityNaquadahReactorController) {
                TileEntityNaquadahReactorController reactorBlock = (TileEntityNaquadahReactorController)((Object)tile);
                reactorBlock.setInjectionRateFromPacket((int)Math.round(extra));
            }
        })),
        LOGIC_TYPE((TriConsumer<TileEntityMekanism, Player, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityNaquadahReactorLogicAdapter) {
                TileEntityNaquadahReactorLogicAdapter logicAdapter = (TileEntityNaquadahReactorLogicAdapter)((Object)tile);
                logicAdapter.setLogicTypeFromPacket(TileEntityNaquadahReactorLogicAdapter.NaquadahReactorLogic.byIndexStatic((int)Math.round(extra)));
            }
        }));

        private final TriConsumer<TileEntityMekanism, Player, Double> consumerForTile;

        private ExtraGeneratorsGuiInteraction(TriConsumer<TileEntityMekanism, Player, Double> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, Player player, double extra) {
            this.consumerForTile.accept((Object)tile, (Object)player, (Object)extra);
        }
    }
}

