/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.phys.Vec3;

public class Noise3D {
    public final int sizeX;
    public final int sizeY;
    public final int sizeZ;
    public final int scale;
    public NoisePoint[][][] noisePoints;
    public List<NoisePoint> startingPoints = new ArrayList<NoisePoint>();

    public Noise3D(int sizeX, int sizeY, int sizeZ, int scale) {
        this.sizeX = sizeX - 1;
        this.sizeY = sizeY - 1;
        this.sizeZ = sizeZ - 1;
        this.scale = scale;
        this.noisePoints = new NoisePoint[sizeX][sizeY][sizeZ];
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    this.noisePoints[x][y][z] = new NoisePoint(new Vec3((double)x, (double)y, (double)z));
                }
            }
        }
        this.calculateStartingPoints();
        this.calculateNoise();
    }

    public void calculateStartingPoints() {
        for (int x = 0; x < this.sizeX; x += this.scale) {
            for (int y = 0; y < this.sizeY; y += this.scale) {
                for (int z = 0; z < this.sizeZ; z += this.scale) {
                    if (x > this.sizeX || y > this.sizeY) continue;
                    if (x == 0 || y == 0 || z == 0 || x == this.sizeX || y == this.sizeY || z == this.sizeZ) {
                        this.noisePoints[x][y][z].setValue(0.0);
                        continue;
                    }
                    this.noisePoints[x][y][z].setValue(Math.random());
                }
            }
        }
    }

    public void calculateNoise() {
        int z;
        int y;
        int x;
        for (x = 0; x < this.sizeX; ++x) {
            for (y = 0; y < this.sizeY; y += this.scale) {
                for (z = 0; z < this.sizeZ; z += this.scale) {
                    if (this.noisePoints[x][y][z].isSet()) continue;
                    int previousX = x - x % this.scale;
                    int nextX = previousX + this.scale >= this.sizeX ? this.sizeX - 1 : previousX + this.scale;
                    this.noisePoints[x][y][z].setValue(this.noisePoints[previousX][y][z].getValue() - (this.noisePoints[previousX][y][z].getValue() / (double)this.scale - this.noisePoints[nextX][y][z].getValue() / (double)this.scale) * (double)(x % this.scale));
                }
            }
        }
        for (x = 0; x < this.sizeX; ++x) {
            for (y = 0; y < this.sizeY; ++y) {
                for (z = 0; z < this.sizeZ; z += this.scale) {
                    if (this.noisePoints[x][y][z].isSet()) continue;
                    int previousY = y - y % this.scale;
                    int nextY = previousY + this.scale >= this.sizeY ? this.sizeY - 1 : previousY + this.scale;
                    this.noisePoints[x][y][z].setValue(this.noisePoints[x][previousY][z].getValue() - (this.noisePoints[x][previousY][z].getValue() / (double)this.scale - this.noisePoints[x][nextY][z].getValue() / (double)this.scale) * (double)(y % this.scale));
                }
            }
        }
        for (x = 0; x < this.sizeX; ++x) {
            for (y = 0; y < this.sizeY; ++y) {
                for (z = 0; z < this.sizeZ; ++z) {
                    if (this.noisePoints[x][y][z].isSet()) continue;
                    int previousZ = z - z % this.scale;
                    int nextZ = previousZ + this.scale >= this.sizeZ ? this.sizeZ - 1 : previousZ + this.scale;
                    this.noisePoints[x][y][z].setValue(this.noisePoints[x][y][previousZ].getValue() - (this.noisePoints[x][y][previousZ].getValue() / (double)this.scale - this.noisePoints[x][y][nextZ].getValue() / (double)this.scale) * (double)(z % this.scale));
                }
            }
        }
    }

    public double getValue(int x, int y, int z) {
        if (x > this.sizeX || y > this.sizeY || z > this.sizeZ || x == 0 || y == 0 || z == 0) {
            return 0.0;
        }
        return this.noisePoints[x][y][z].getValue();
    }

    public static class NoisePoint {
        private Vec3 position;
        private double value;
        private boolean set;

        public NoisePoint(Vec3 position) {
            this.position = position;
        }

        public void setValue(double value) {
            this.value = value;
            this.set = true;
        }

        public Vec3 getPosition() {
            return this.position;
        }

        public double getValue() {
            return this.value;
        }

        public boolean isSet() {
            return this.set;
        }
    }
}

