/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects.projectile;

import luckytnt.registry.ItemRegistry;
import luckytntlib.entity.LExplosiveProjectile;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class TimerDynamiteEffect
extends PrimedTNTEffect {
    public void baseTick(IExplosiveEntity entity) {
        Level level = entity.getLevel();
        if (entity instanceof LExplosiveProjectile) {
            LExplosiveProjectile ent = (LExplosiveProjectile)entity;
            if (ent.inGround() || ent.hitEntity()) {
                ent.getPersistentData().m_128379_("hitBefore", true);
            }
            if (ent.getTNTFuse() == 0) {
                if (ent.m_9236_() instanceof ServerLevel) {
                    entity.getLevel().m_245803_((Entity)entity, this.toBlockPos(entity.getPos()), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
                    this.serverExplosion(entity);
                }
                ent.destroy();
            }
            if (ent.inGround() || ent.getPersistentData().m_128471_("hitBefore")) {
                this.explosionTick((IExplosiveEntity)ent);
                ent.setTNTFuse(ent.getTNTFuse() - 1);
            }
            if (level.f_46443_) {
                this.spawnParticles(entity);
            }
        }
    }

    public void serverExplosion(IExplosiveEntity entity) {
        ImprovedExplosion explosion = new ImprovedExplosion(entity.getLevel(), (Entity)entity, entity.getPos(), 5);
        explosion.doEntityExplosion(1.0f, true);
        explosion.doBlockExplosion();
    }

    public void spawnParticles(IExplosiveEntity entity) {
        float r = entity.getTNTFuse() < 200 ? 1.0f : 2.0f - 0.005f * (float)entity.getTNTFuse();
        float g = entity.getTNTFuse() >= 200 ? 1.0f : 0.005f * (float)entity.getTNTFuse();
        entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, 0.0f), 1.0f), entity.x(), entity.y(), entity.z(), 0.0, 0.0, 0.0);
    }

    public Item getItem() {
        return (Item)ItemRegistry.TIMER_DYNAMITE.get();
    }

    public int getDefaultFuse(IExplosiveEntity entity) {
        return 400;
    }
}

