/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects.projectile;

import luckytnt.registry.ItemRegistry;
import luckytntlib.entity.LExplosiveProjectile;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class PulseDynamiteEffect
extends PrimedTNTEffect {
    public void baseTick(IExplosiveEntity entity) {
        Level level = entity.getLevel();
        if (entity instanceof LExplosiveProjectile) {
            LExplosiveProjectile ent = (LExplosiveProjectile)entity;
            if (ent.inGround()) {
                ent.getPersistentData().m_128379_("hitBefore", true);
            }
            if (ent.getTNTFuse() == 0) {
                ent.destroy();
            }
            if (ent.inGround() || ent.getPersistentData().m_128471_("hitBefore")) {
                this.explosionTick((IExplosiveEntity)ent);
                ent.setTNTFuse(ent.getTNTFuse() - 1);
            }
            if (level.f_46443_) {
                this.spawnParticles(entity);
            }
        }
    }

    public void explosionTick(IExplosiveEntity entity) {
        Level level = entity.getLevel();
        if (entity.getTNTFuse() <= 185) {
            ((Entity)entity).m_20334_(0.0, 0.0, 0.0);
            ((Entity)entity).m_146884_(((Entity)entity).m_20318_(0.0f));
            if (entity.getTNTFuse() % 20 == 0 && entity.getLevel() instanceof ServerLevel) {
                ImprovedExplosion explosion = new ImprovedExplosion(entity.getLevel(), (Entity)entity, entity.getPos(), entity.getPersistentData().m_128451_("strength"));
                explosion.doEntityExplosion(1.0f, true);
                explosion.doBlockExplosion(1.0f, 1.0f, 1.0f, 1.25f, false, false);
                level.m_245803_((Entity)entity, this.toBlockPos(entity.getPos()), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
                entity.getPersistentData().m_128405_("strength", entity.getPersistentData().m_128451_("strength") + 1);
            }
        }
    }

    public void spawnParticles(IExplosiveEntity entity) {
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        for (int i = 0; i < 200; ++i) {
            double y = 1.0 - (double)i / 199.0 * 2.0;
            double radius = Math.sqrt(1.0 - y * y);
            double theta = phi * (double)i;
            double x = Math.cos(theta) * radius;
            double z = Math.sin(theta) * radius;
            entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.4f, 0.4f, 1.0f), 0.75f), entity.x() + x, entity.y() + y + 0.5, entity.z() + z, 0.0, 0.0, 0.0);
        }
    }

    public boolean explodesOnImpact() {
        return false;
    }

    public Item getItem() {
        return (Item)ItemRegistry.PULSE_DYNAMITE.get();
    }

    public int getDefaultFuse(IExplosiveEntity entity) {
        return 300;
    }
}

