/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects.projectile;

import luckytnt.registry.EntityRegistry;
import luckytnt.registry.ItemRegistry;
import luckytntlib.entity.LExplosiveProjectile;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class MultiplyingDynamiteEffect
extends PrimedTNTEffect {
    public void baseTick(IExplosiveEntity entity) {
        Level level = entity.getLevel();
        if (entity instanceof LExplosiveProjectile) {
            LExplosiveProjectile ent = (LExplosiveProjectile)entity;
            if (ent.inGround() && ent.getPersistentData().m_128451_("level") >= 3 && level instanceof ServerLevel) {
                this.serverExplosion((IExplosiveEntity)ent);
                ent.destroy();
            }
            if (ent.getTNTFuse() == 0 && level instanceof ServerLevel) {
                this.serverExplosion((IExplosiveEntity)ent);
                ent.destroy();
            }
            if (ent.getPersistentData().m_128451_("level") < 3) {
                this.explosionTick((IExplosiveEntity)ent);
                ent.setTNTFuse(ent.getTNTFuse() - 1);
            }
            if (level.f_46443_) {
                this.spawnParticles(entity);
            }
        }
    }

    public void serverExplosion(IExplosiveEntity entity) {
        Level level = entity.getLevel();
        if (entity.getPersistentData().m_128451_("level") < 3) {
            for (int count = 0; count < 4; ++count) {
                LExplosiveProjectile dynamite = (LExplosiveProjectile)((EntityType)EntityRegistry.MULTIPLYING_DYNAMITE.get()).m_20615_(entity.getLevel());
                dynamite.m_146884_(entity.getPos());
                dynamite.setOwner(entity.owner());
                dynamite.m_20256_(((Entity)entity).m_20184_().m_82520_(Math.random() * 0.5 - 0.25, Math.random() * 0.5 - 0.25, Math.random() * 0.5 - 0.25));
                dynamite.getPersistentData().m_128405_("level", entity.getPersistentData().m_128451_("level") + 1);
                entity.getLevel().m_7967_((Entity)dynamite);
            }
        } else {
            ImprovedExplosion explosion = new ImprovedExplosion(entity.getLevel(), (Entity)entity, entity.getPos(), 8);
            explosion.doEntityExplosion(0.75f, true);
            explosion.doBlockExplosion(1.0f, 1.0f, 1.0f, 1.25f, false, false);
            level.m_245803_((Entity)entity, this.toBlockPos(entity.getPos()), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
        }
    }

    public void explosionTick(IExplosiveEntity entity) {
        if (entity.getPersistentData().m_128451_("level") < 3) {
            ((Entity)entity).m_20256_(((Entity)entity).m_20184_().m_82520_(0.0, (double)0.08f, 0.0));
        }
    }

    public Item getItem() {
        return (Item)ItemRegistry.MULTIPLYING_DYNAMITE.get();
    }

    public int getDefaultFuse(IExplosiveEntity entity) {
        return 20;
    }
}

