/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects.projectile;

import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ExplosionHelper;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MeteorEffect
extends PrimedTNTEffect {
    private final int strength;
    private final float size;

    public MeteorEffect(int strength, float size) {
        this.strength = strength;
        this.size = size;
    }

    public void serverExplosion(IExplosiveEntity entity) {
        final ImprovedExplosion explosion = new ImprovedExplosion(entity.getLevel(), (Entity)entity, entity.getPos(), this.strength);
        explosion.doEntityExplosion(3.0f, true);
        ExplosionHelper.doSphericalExplosion((Level)entity.getLevel(), (Vec3)entity.getPos(), (int)this.strength, (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                if (distance <= (double)(MeteorEffect.this.strength - MeteorEffect.this.strength / 8) && state.getExplosionResistance((BlockGetter)level, pos, (Explosion)explosion) <= 100.0f) {
                    state.onBlockExploded(level, pos, (Explosion)explosion);
                } else if (Math.random() < (double)0.6f && state.getExplosionResistance((BlockGetter)level, pos, (Explosion)explosion) <= 100.0f) {
                    state.onBlockExploded(level, pos, (Explosion)explosion);
                    if (Math.random() < 0.25 && level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos, Direction.UP)) {
                        level.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)pos));
                    }
                }
            }
        });
    }

    public void spawnParticles(IExplosiveEntity entity) {
        entity.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123813_, entity.x(), entity.y() + (double)this.size, entity.z(), 0.0, 0.0, 0.0);
    }

    public float getSize(IExplosiveEntity entity) {
        return this.size;
    }

    public Block getBlock() {
        return Blocks.f_50450_;
    }
}

