/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects.projectile;

import java.util.List;
import javax.annotation.Nullable;
import luckytnt.registry.ItemRegistry;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HomingDynamiteEffect
extends PrimedTNTEffect {
    public void serverExplosion(IExplosiveEntity entity) {
        ImprovedExplosion explosion = new ImprovedExplosion(entity.getLevel(), (Entity)entity, entity.getPos(), 20);
        explosion.doEntityExplosion(1.5f, true);
        explosion.doBlockExplosion(1.0f, 1.0f, 1.0f, 1.25f, false, false);
    }

    public void explosionTick(IExplosiveEntity entity) {
        if (entity.getTNTFuse() < 390) {
            Entity target = entity.getLevel().m_6815_(entity.getPersistentData().m_128451_("targetID"));
            if (target == null) {
                target = this.setTarget(entity);
            } else {
                Vec3 movement = target.m_20318_(1.0f).m_82546_(entity.getPos()).m_82541_();
                ((Entity)entity).m_20256_(movement);
                Level level = entity.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    for (ServerPlayer splayer : server.m_6907_()) {
                        splayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(((Entity)entity).m_19879_(), ((Entity)entity).m_20184_()));
                    }
                }
            }
        }
    }

    @Nullable
    public Entity setTarget(IExplosiveEntity entity) {
        Level level = entity.getLevel();
        Player target = null;
        List players = level.m_45976_(Player.class, new AABB(entity.getPos().m_82520_(-100.0, -100.0, -100.0), entity.getPos().m_82520_(100.0, 100.0, 100.0)));
        double distance = Math.sqrt(20000.0);
        for (Player player : players) {
            double entityDistance = entity.getPos().m_82554_(player.m_20318_(1.0f));
            if (player.equals((Object)entity.owner()) || !(entityDistance <= distance)) continue;
            entity.getPersistentData().m_128405_("targetID", player.m_19879_());
            distance = entityDistance;
            target = player;
        }
        if (target == null) {
            distance = Math.sqrt(20000.0);
            List livingEntities = level.m_45976_(LivingEntity.class, new AABB(entity.getPos().m_82520_(-100.0, -100.0, -100.0), entity.getPos().m_82520_(100.0, 100.0, 100.0)));
            for (LivingEntity ent : livingEntities) {
                double entityDistance = entity.getPos().m_82554_(ent.m_20318_(1.0f));
                if (ent.equals((Object)entity.owner()) || !(entityDistance <= distance)) continue;
                entity.getPersistentData().m_128405_("targetID", ent.m_19879_());
                distance = entityDistance;
                target = ent;
            }
        }
        return target;
    }

    public boolean airFuse() {
        return true;
    }

    public Item getItem() {
        return (Item)ItemRegistry.HOMING_DYNAMITE.get();
    }

    public int getDefaultFuse(IExplosiveEntity entity) {
        return 400;
    }
}

