/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects.projectile;

import luckytnt.registry.EntityRegistry;
import luckytnt.registry.ItemRegistry;
import luckytntlib.entity.LExplosiveProjectile;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class EruptingDynamiteEffect
extends PrimedTNTEffect {
    public void baseTick(IExplosiveEntity entity) {
        Level level = entity.getLevel();
        if (entity instanceof LExplosiveProjectile) {
            LExplosiveProjectile ent = (LExplosiveProjectile)entity;
            if (ent.inGround()) {
                ent.getPersistentData().m_128379_("hitBefore", true);
            }
            if (ent.getTNTFuse() == 0) {
                ent.destroy();
            }
            if (ent.inGround() || ent.getPersistentData().m_128471_("hitBefore")) {
                this.explosionTick((IExplosiveEntity)ent);
                ent.setTNTFuse(ent.getTNTFuse() - 1);
            }
            if (level.f_46443_) {
                this.spawnParticles(entity);
            }
        }
    }

    public void explosionTick(IExplosiveEntity entity) {
        Level level = entity.getLevel();
        if (entity.getTNTFuse() < 15 && entity.getTNTFuse() % 3 == 0) {
            LExplosiveProjectile erupting_tnt = (LExplosiveProjectile)((EntityType)EntityRegistry.ERUPTING_PROJECTILE.get()).m_20615_(level);
            erupting_tnt.m_146884_(entity.getPos());
            erupting_tnt.setOwner(entity.owner());
            erupting_tnt.m_6686_((Math.random() * 2.0 - 1.0) * (double)0.1f, (double)0.6f + Math.random() * (double)0.4f, (Math.random() * 2.0 - 1.0) * (double)0.1f, 2.0f + level.f_46441_.m_188501_(), 0.0f);
            erupting_tnt.m_20254_(1000);
            level.m_7967_((Entity)erupting_tnt);
            level.m_5594_(null, this.toBlockPos(entity.getPos()), SoundEvents.f_11913_, SoundSource.MASTER, 3.0f, 1.0f);
        }
    }

    public void spawnParticles(IExplosiveEntity entity) {
        entity.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123744_, entity.x(), entity.y(), entity.z(), 0.0, 0.0, 0.0);
    }

    public Item getItem() {
        return (Item)ItemRegistry.ERUPTING_DYNAMITE.get();
    }

    public int getDefaultFuse(IExplosiveEntity entity) {
        return 40;
    }
}

