/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects.projectile;

import java.util.List;
import luckytnt.registry.BlockRegistry;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ExplosionHelper;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class DisintegratingProjectileEffect
extends PrimedTNTEffect {
    public void baseTick(IExplosiveEntity entity) {
        if (!entity.getLevel().m_5776_()) {
            this.explosionTick(entity);
        } else {
            this.spawnParticles(entity);
        }
        entity.setTNTFuse(entity.getTNTFuse() - 1);
        if (entity.getTNTFuse() <= 0) {
            entity.destroy();
        }
    }

    public void explosionTick(final IExplosiveEntity ent) {
        if (ent.getTNTFuse() == 0) {
            ent.getLevel().m_5594_(null, this.toBlockPos(ent.getPos()), SoundEvents.f_11937_, SoundSource.MASTER, 1.0f, 1.0f);
        }
        if (!ent.getLevel().m_5776_()) {
            ExplosionHelper.doCubicalExplosion((Level)ent.getLevel(), (Vec3)ent.getPos(), (int)12, (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

                public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                    if (distance < 10.0 + Math.random() * 2.0) {
                        if (state.getExplosionResistance((BlockGetter)level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)ent.getLevel())) < 200.0f) {
                            state.onBlockExploded(level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)ent.getLevel()));
                        }
                    } else if (distance > 11.0 && distance <= 13.0 && state.m_60734_() == Blocks.f_50069_ && Math.random() < 0.01) {
                        level.m_7731_(pos, ((Block)BlockRegistry.TOXIC_STONE.get()).m_49966_(), 3);
                    }
                }
            });
        }
        if (ent.getTNTFuse() % 20 == 0) {
            List list = ent.getLevel().m_45976_(LivingEntity.class, new AABB(this.toBlockPos(ent.getPos()).m_7918_(-6, -6, -6), this.toBlockPos(ent.getPos()).m_7918_(6, 6, 6)));
            DamageSources sources = new DamageSources(ent.getLevel().m_9598_());
            for (LivingEntity lent : list) {
                lent.m_6469_(sources.m_269425_(), 5.0f);
            }
        }
    }

    public void spawnParticles(IExplosiveEntity ent) {
        ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), ent.x() + (double)0.2f, ent.y() + 1.0, ent.z(), 0.0, 0.0, 0.0);
        ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), ent.x() - (double)0.2f, ent.y() + 1.0, ent.z(), 0.0, 0.0, 0.0);
        ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f), ent.x(), ent.y() + 1.0, ent.z() + (double)0.2f, 0.0, 0.0, 0.0);
        ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f), ent.x(), ent.y() + 1.0, ent.z() - (double)0.2f, 0.0, 0.0, 0.0);
    }

    public Block getBlock() {
        return (Block)BlockRegistry.DISINTEGRATING_TNT.get();
    }

    public int getDefaultFuse(IExplosiveEntity ent) {
        return 120;
    }
}

