/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects.projectile;

import java.util.Random;
import luckytnt.registry.EntityRegistry;
import luckytnt.registry.ItemRegistry;
import luckytnt.tnteffects.SnowTNTEffect;
import luckytntlib.entity.LExplosiveProjectile;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;

public class ChristmasDynamiteEffect
extends PrimedTNTEffect {
    public void baseTick(IExplosiveEntity entity) {
        Level level = entity.getLevel();
        if (entity instanceof LExplosiveProjectile) {
            LExplosiveProjectile ent = (LExplosiveProjectile)entity;
            if (ent.inGround() && ent.getTNTFuse() < 60) {
                if (level instanceof ServerLevel) {
                    level.m_245803_((Entity)entity, this.toBlockPos(entity.getPos()), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
                    this.serverExplosion((IExplosiveEntity)ent);
                }
                ent.destroy();
            }
            if (ent.getTNTFuse() > 0) {
                this.explosionTick((IExplosiveEntity)ent);
                ent.setTNTFuse(ent.getTNTFuse() - 1);
            }
            if (level.f_46443_) {
                this.spawnParticles(entity);
            }
        }
    }

    public void serverExplosion(IExplosiveEntity entity) {
        SnowTNTEffect snowEffect = new SnowTNTEffect(25);
        snowEffect.serverExplosion(entity);
        ((ServerLevel)entity.getLevel()).m_8767_((ParticleOptions)ParticleTypes.f_175829_, entity.x() + Math.random() - 0.5, entity.y() + Math.random() - 0.5, entity.z() + Math.random() - 0.5, 500, 0.5, 0.5, 0.5, 0.0);
    }

    public void explosionTick(IExplosiveEntity entity) {
        if (entity.getTNTFuse() == 220) {
            entity.getPersistentData().m_128347_("vecx", ((Entity)entity).m_20184_().f_82479_);
            entity.getPersistentData().m_128347_("vecz", ((Entity)entity).m_20184_().f_82481_);
        }
        if (entity.getTNTFuse() <= 220 && entity.getTNTFuse() > 60) {
            ((Entity)entity).m_20256_(new Vec3(entity.getPersistentData().m_128459_("vecx"), 0.0, entity.getPersistentData().m_128459_("vecz")).m_82541_().m_82490_(0.25));
            if (entity.getTNTFuse() % 20 == 0) {
                LExplosiveProjectile dynamite = (LExplosiveProjectile)((EntityType)EntityRegistry.CHRISTMAS_DYNAMITE_PROJECTILE.get()).m_20615_(entity.getLevel());
                dynamite.m_146884_(entity.getPos());
                dynamite.setOwner(entity.owner());
                double randomX = Math.random();
                double randomZ = Math.random();
                dynamite.m_20334_(randomX *= new Random().nextBoolean() ? 1.0 : -1.0, -Math.random() * 0.5, randomZ *= new Random().nextBoolean() ? 1.0 : -1.0);
                entity.getLevel().m_7967_((Entity)dynamite);
            }
        } else if (entity.getTNTFuse() > 60) {
            ((Entity)entity).m_20256_(((Entity)entity).m_20184_().m_82520_(0.0, (double)0.08f, 0.0));
        }
    }

    public void spawnParticles(IExplosiveEntity entity) {
        for (int i = 0; i < 7; ++i) {
            entity.getLevel().m_6493_((ParticleOptions)ParticleTypes.f_175829_, true, entity.x() + Math.random() - 0.5, entity.y() + Math.random() - 0.5, entity.z() + Math.random() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    public boolean explodesOnImpact() {
        return false;
    }

    public boolean airFuse() {
        return true;
    }

    public Item getItem() {
        return (Item)ItemRegistry.CHRISTMAS_DYNAMITE.get();
    }

    public int getDefaultFuse(IExplosiveEntity entity) {
        return 260;
    }
}

