/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects.projectile;

import luckytnt.registry.ItemRegistry;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ExplosionHelper;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ChemicalDynamiteEffect
extends PrimedTNTEffect {
    public void explosionTick(final IExplosiveEntity entity) {
        if (entity.getLevel() instanceof ServerLevel) {
            ExplosionHelper.doSphericalExplosion((Level)entity.getLevel(), (Vec3)entity.getPos(), (int)4, (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

                public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                    if (state.getExplosionResistance((BlockGetter)level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)entity.getLevel())) < 100.0f && distance + Math.random() <= 4.0) {
                        state.onBlockExploded(level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)entity.getLevel()));
                    }
                }
            });
        }
    }

    public void spawnParticles(IExplosiveEntity entity) {
        entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.1f, 1.0f, 0.6f), 1.0f), entity.x(), entity.y(), entity.z(), 0.0, 0.0, 0.0);
        entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.6f, 0.8f, 0.4f), 1.0f), entity.x(), entity.y(), entity.z(), 0.0, 0.0, 0.0);
        entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.8f, 1.0f, 0.8f), 1.0f), entity.x(), entity.y(), entity.z(), 0.0, 0.0, 0.0);
        entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.1f, 1.0f, 0.2f), 1.0f), entity.x(), entity.y(), entity.z(), 0.0, 0.0, 0.0);
    }

    public boolean playsSound() {
        return false;
    }

    public boolean airFuse() {
        return true;
    }

    public boolean explodesOnImpact() {
        return false;
    }

    public Item getItem() {
        return (Item)ItemRegistry.CHEMICAL_DYNAMITE.get();
    }

    public int getDefaultFuse(IExplosiveEntity entity) {
        return 40;
    }
}

