/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import luckytnt.registry.BlockRegistry;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WitheringTNTEffect
extends PrimedTNTEffect {
    private final int strength;

    public WitheringTNTEffect(int strength) {
        this.strength = strength;
    }

    public void serverExplosion(IExplosiveEntity entity) {
        final ImprovedExplosion explosion = new ImprovedExplosion(entity.getLevel(), (Entity)entity, entity.getPos(), this.strength);
        explosion.doEntityExplosion(2.0f, true);
        explosion.doBlockExplosion(1.0f, 1.0f, 1.0f, 1.5f, false, false);
        explosion.doBlockExplosion(new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                if (state.m_60838_((BlockGetter)level, pos)) {
                    state.onBlockExploded(level, pos, (Explosion)explosion);
                    level.m_46597_(pos, Math.random() < 0.5 ? Blocks.f_50135_.m_49966_() : Blocks.f_50136_.m_49966_());
                }
            }
        });
        int i = 0;
        while ((float)i < (float)this.strength * 2.0f) {
            int offX = (int)Math.round(Math.random() * (double)this.strength * 2.0 - (double)this.strength);
            int offZ = (int)Math.round(Math.random() * (double)this.strength * 2.0 - (double)this.strength);
            WitherSkeleton skeleton = new WitherSkeleton(EntityType.f_20497_, entity.getLevel());
            Level level = entity.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                skeleton.m_6518_((ServerLevelAccessor)sl, entity.getLevel().m_6436_(this.toBlockPos(entity.getPos())), MobSpawnType.MOB_SUMMONED, null, null);
            }
            for (int y = entity.getLevel().m_151558_(); y >= entity.getLevel().m_141937_(); --y) {
                BlockPos pos = new BlockPos(Mth.m_14107_((double)(entity.x() + (double)offX)), y, Mth.m_14107_((double)(entity.z() + (double)offZ)));
                BlockState state = entity.getLevel().m_8055_(pos);
                if (Block.m_49918_((VoxelShape)state.m_60812_((BlockGetter)entity.getLevel(), pos), (Direction)Direction.UP) || !Block.m_49918_((VoxelShape)entity.getLevel().m_8055_(pos.m_7495_()).m_60812_((BlockGetter)entity.getLevel(), pos.m_7495_()), (Direction)Direction.UP)) continue;
                skeleton.m_6034_((double)((float)pos.m_123341_() + 0.5f), (double)y, (double)((float)pos.m_123343_() + 0.5f));
                break;
            }
            entity.getLevel().m_7967_((Entity)skeleton);
            ++i;
        }
    }

    public int getDefaultFuse(IExplosiveEntity entity) {
        return 160;
    }

    public Block getBlock() {
        return (Block)BlockRegistry.WITHERING_TNT.get();
    }
}

