/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.util.List;
import luckytnt.registry.BlockRegistry;
import luckytnt.util.Materials;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.WetSpongeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;

public class WastelandTNTEffect
extends PrimedTNTEffect {
    public static List<Block> GRASS = List.of(Blocks.f_50440_, Blocks.f_50599_, Blocks.f_50195_, Blocks.f_220864_, Blocks.f_220834_);
    public static List<Block> DIRT = List.of(Blocks.f_50493_, Blocks.f_50546_, Blocks.f_152549_);

    public void serverExplosion(IExplosiveEntity ent) {
        WastelandTNTEffect.doVaporizeExplosion(ent, 75.0, true);
    }

    public void spawnParticles(IExplosiveEntity ent) {
        for (int count = 0; count < 100; ++count) {
            ent.getLevel().m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, ent.x() + Math.random() * 30.0 - Math.random() * 30.0, ent.y() + 0.5, ent.z() + Math.random() * 30.0 - Math.random() * 30.0, 0.0, 0.0, 0.0);
        }
    }

    public Block getBlock() {
        return (Block)BlockRegistry.WASTELAND_TNT.get();
    }

    public int getDefaultFuse(IExplosiveEntity ent) {
        return 180;
    }

    public static void doVaporizeExplosion(IExplosiveEntity ent, double radius, boolean dryArea) {
        if (!ent.getLevel().m_5776_()) {
            for (double offX = -radius; offX <= radius; offX += 1.0) {
                for (double offY = -radius; offY <= radius; offY += 1.0) {
                    for (double offZ = -radius; offZ <= radius; offZ += 1.0) {
                        double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
                        BlockPos pos = new BlockPos(Mth.m_14107_((double)(ent.x() + offX)), Mth.m_14107_((double)(ent.y() + offY)), Mth.m_14107_((double)(ent.z() + offZ)));
                        BlockPos posDown = pos.m_7918_(0, -1, 0);
                        BlockState state = ent.getLevel().m_8055_(pos);
                        BlockState stateDown = ent.getLevel().m_8055_(posDown);
                        if (!(distance <= radius)) continue;
                        if (state.m_60734_() instanceof LiquidBlock || Materials.isWaterPlant(state) || state.m_60713_(Blocks.f_50628_)) {
                            ent.getLevel().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                        }
                        if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                            ent.getLevel().m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
                        }
                        if (!dryArea) continue;
                        if (Materials.isPlant(state) && stateDown.canSustainPlant((BlockGetter)ent.getLevel(), posDown, Direction.UP, (IPlantable)Blocks.f_50036_)) {
                            ent.getLevel().m_7731_(pos, Blocks.f_50036_.m_49966_(), 3);
                        }
                        if (GRASS.contains(state.m_60734_())) {
                            ent.getLevel().m_7731_(pos, Blocks.f_50493_.m_49966_(), 3);
                            continue;
                        }
                        if (DIRT.contains(state.m_60734_())) {
                            ent.getLevel().m_7731_(pos, Blocks.f_49992_.m_49966_(), 3);
                            continue;
                        }
                        if (state.m_204336_(BlockTags.f_13089_)) {
                            ent.getLevel().m_7731_(pos, Blocks.f_50041_.m_49966_(), 3);
                            continue;
                        }
                        if (state.m_60734_() instanceof WetSpongeBlock) {
                            ent.getLevel().m_7731_(pos, Blocks.f_50056_.m_49966_(), 3);
                            continue;
                        }
                        if (!state.m_204336_(BlockTags.f_13047_) && !state.m_204336_(BlockTags.f_144279_) && !state.m_204336_(BlockTags.f_13035_)) continue;
                        ent.getLevel().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    }
                }
            }
        }
    }
}

