/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import luckytnt.block.StructureTNTBlock;
import luckytnt.registry.BlockRegistry;
import luckytnt.tnteffects.JungleTNTEffect;
import luckytnt.util.StructureStates;
import luckytntlib.block.LTNTBlock;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BastionPieces;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.SinglePieceStructure;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidPiece;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidStructure;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentPieces;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class StructureTNTEffect
extends PrimedTNTEffect {
    public com.google.common.base.Predicate<Holder<Biome>> PREDICATE = holder -> true;

    public void serverExplosion(IExplosiveEntity ent) {
        String value = ent.getPersistentData().m_128461_("structure");
        Level level = ent.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            RegistryAccess rAccess = sLevel.m_9598_();
            ChunkGenerator chunkGenerator = sLevel.m_7726_().m_8481_();
            BiomeSource biomeSource = sLevel.m_7726_().m_8481_().m_62218_();
            StructureTemplateManager sManager = sLevel.m_215082_();
            StructureManager sFManager = sLevel.m_215010_();
            BoundingBox bb = new BoundingBox((int)ent.x() - 150, (int)ent.y() - 150, (int)ent.z() - 150, (int)ent.x() + 150, (int)ent.y() + 150, (int)ent.z() + 150);
            ChunkPos chunkPosition = ((Entity)ent).m_146902_();
            RandomSource random = RandomSource.m_216327_();
            RandomState randomState = sLevel.m_7726_().m_214994_();
            Registry registry = sLevel.m_9598_().m_175515_(Registries.f_256944_);
            Registry pools = sLevel.m_9598_().m_175515_(Registries.f_256948_);
            Holder pool = pools.m_263177_((Object)((StructureTemplatePool)pools.m_6246_(BastionPieces.f_126673_)));
            Structure pillager_outpost = (Structure)registry.m_6246_(BuiltinStructures.f_209845_);
            Structure mansion = (Structure)registry.m_6246_(BuiltinStructures.f_209848_);
            Structure jungle_pyramid = (Structure)registry.m_6246_(BuiltinStructures.f_209849_);
            DesertPyramid desert_pyramid = new DesertPyramid(null);
            Structure stronghold = (Structure)registry.m_6246_(BuiltinStructures.f_209855_);
            Monument monument = new Monument(null);
            Structure fortress = (Structure)registry.m_6246_(BuiltinStructures.f_209859_);
            Structure end_city = (Structure)registry.m_6246_(BuiltinStructures.f_209861_);
            JigsawStructure bastion = new JigsawStructure(null, pool, 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)((int)ent.y()))), false);
            Structure village_plains = (Structure)registry.m_6246_(BuiltinStructures.f_209864_);
            Structure village_desert = (Structure)registry.m_6246_(BuiltinStructures.f_209865_);
            Structure village_savanna = (Structure)registry.m_6246_(BuiltinStructures.f_209866_);
            Structure village_snowy = (Structure)registry.m_6246_(BuiltinStructures.f_209867_);
            Structure village_taiga = (Structure)registry.m_6246_(BuiltinStructures.f_209868_);
            if (value.equals("pillager_outpost")) {
                StructureStart start = pillager_outpost.m_226596_(rAccess, chunkGenerator, biomeSource, randomState, sManager, sLevel.m_7328_(), chunkPosition, 20, (LevelHeightAccessor)sLevel, this.PREDICATE);
                start.m_226850_((WorldGenLevel)sLevel, sFManager, chunkGenerator, random, bb, chunkPosition);
            } else if (value.equals("mansion")) {
                StructureStart start = mansion.m_226596_(rAccess, chunkGenerator, biomeSource, randomState, sManager, sLevel.m_7328_(), chunkPosition, 20, (LevelHeightAccessor)sLevel, this.PREDICATE);
                start.m_226850_((WorldGenLevel)sLevel, sFManager, chunkGenerator, random, bb, chunkPosition);
            } else if (value.equals("jungle_pyramid")) {
                StructureStart start = jungle_pyramid.m_226596_(rAccess, chunkGenerator, biomeSource, randomState, sManager, sLevel.m_7328_(), chunkPosition, 20, (LevelHeightAccessor)sLevel, this.PREDICATE);
                start.m_226850_((WorldGenLevel)sLevel, sFManager, chunkGenerator, random, bb, chunkPosition);
            } else if (value.equals("desert_pyramid")) {
                StructureStart start = desert_pyramid.m_226596_(rAccess, chunkGenerator, biomeSource, randomState, sManager, sLevel.m_7328_(), chunkPosition, 20, (LevelHeightAccessor)sLevel, (Predicate)this.PREDICATE);
                start.m_226850_((WorldGenLevel)sLevel, sFManager, chunkGenerator, random, bb, chunkPosition);
            } else if (value.equals("stronghold")) {
                StructureStart start = stronghold.m_226596_(rAccess, chunkGenerator, biomeSource, randomState, sManager, sLevel.m_7328_(), chunkPosition, 20, (LevelHeightAccessor)sLevel, this.PREDICATE);
                start.m_226850_((WorldGenLevel)sLevel, sFManager, chunkGenerator, random, bb, chunkPosition);
            } else if (value.equals("monument")) {
                StructureStart start = monument.m_226596_(rAccess, chunkGenerator, biomeSource, randomState, sManager, sLevel.m_7328_(), chunkPosition, 20, (LevelHeightAccessor)sLevel, (Predicate)this.PREDICATE);
                start.m_226850_((WorldGenLevel)sLevel, sFManager, chunkGenerator, random, bb, chunkPosition);
            } else if (value.equals("fortress")) {
                StructureStart start = fortress.m_226596_(rAccess, chunkGenerator, biomeSource, randomState, sManager, sLevel.m_7328_(), chunkPosition, 20, (LevelHeightAccessor)sLevel, this.PREDICATE);
                start.m_226850_((WorldGenLevel)sLevel, sFManager, chunkGenerator, random, bb, chunkPosition);
            } else if (value.equals("end_city")) {
                StructureStart start = end_city.m_226596_(rAccess, chunkGenerator, biomeSource, randomState, sManager, sLevel.m_7328_(), chunkPosition, 20, (LevelHeightAccessor)sLevel, this.PREDICATE);
                start.m_226850_((WorldGenLevel)sLevel, sFManager, chunkGenerator, random, bb, chunkPosition);
            } else if (value.equals("bastion")) {
                StructureStart start = bastion.m_226596_(rAccess, chunkGenerator, biomeSource, randomState, sManager, sLevel.m_7328_(), chunkPosition, 20, (LevelHeightAccessor)sLevel, this.PREDICATE);
                start.m_226850_((WorldGenLevel)sLevel, sFManager, chunkGenerator, random, bb, chunkPosition);
            } else if (value.equals("village_plains")) {
                JungleTNTEffect.replaceNonSolidBlockOrVegetationWithAir(ent, 100.0, 10.0f, true);
                StructureStart start = village_plains.m_226596_(rAccess, chunkGenerator, biomeSource, randomState, sManager, sLevel.m_7328_(), chunkPosition, 20, (LevelHeightAccessor)sLevel, this.PREDICATE);
                start.m_226850_((WorldGenLevel)sLevel, sFManager, chunkGenerator, random, bb, chunkPosition);
            } else if (value.equals("village_desert")) {
                JungleTNTEffect.replaceNonSolidBlockOrVegetationWithAir(ent, 100.0, 10.0f, true);
                StructureStart start = village_desert.m_226596_(rAccess, chunkGenerator, biomeSource, randomState, sManager, sLevel.m_7328_(), chunkPosition, 20, (LevelHeightAccessor)sLevel, this.PREDICATE);
                start.m_226850_((WorldGenLevel)sLevel, sFManager, chunkGenerator, random, bb, chunkPosition);
            } else if (value.equals("village_savanna")) {
                JungleTNTEffect.replaceNonSolidBlockOrVegetationWithAir(ent, 100.0, 10.0f, true);
                StructureStart start = village_savanna.m_226596_(rAccess, chunkGenerator, biomeSource, randomState, sManager, sLevel.m_7328_(), chunkPosition, 20, (LevelHeightAccessor)sLevel, this.PREDICATE);
                start.m_226850_((WorldGenLevel)sLevel, sFManager, chunkGenerator, random, bb, chunkPosition);
            } else if (value.equals("village_snowy")) {
                JungleTNTEffect.replaceNonSolidBlockOrVegetationWithAir(ent, 100.0, 10.0f, true);
                StructureStart start = village_snowy.m_226596_(rAccess, chunkGenerator, biomeSource, randomState, sManager, sLevel.m_7328_(), chunkPosition, 20, (LevelHeightAccessor)sLevel, this.PREDICATE);
                start.m_226850_((WorldGenLevel)sLevel, sFManager, chunkGenerator, random, bb, chunkPosition);
            } else if (value.equals("village_taiga")) {
                JungleTNTEffect.replaceNonSolidBlockOrVegetationWithAir(ent, 100.0, 10.0f, true);
                StructureStart start = village_taiga.m_226596_(rAccess, chunkGenerator, biomeSource, randomState, sManager, sLevel.m_7328_(), chunkPosition, 20, (LevelHeightAccessor)sLevel, this.PREDICATE);
                start.m_226850_((WorldGenLevel)sLevel, sFManager, chunkGenerator, random, bb, chunkPosition);
            }
        }
    }

    public BlockState getBlockState(IExplosiveEntity ent) {
        boolean bool = false;
        List<StructureStates> list = Arrays.asList(StructureStates.values());
        for (StructureStates state : list) {
            if (!ent.getPersistentData().m_128461_("structure").equals(state.m_7912_())) continue;
            bool = true;
        }
        if (bool) {
            return (BlockState)((LTNTBlock)BlockRegistry.STRUCTURE_TNT.get()).m_49966_().m_61124_(StructureTNTBlock.STRUCTURE, (Comparable)((Object)((StructureStates)((Object)StructureTNTBlock.STRUCTURE.m_6215_(ent.getPersistentData().m_128461_("structure")).get()))));
        }
        return ((LTNTBlock)BlockRegistry.STRUCTURE_TNT.get()).m_49966_();
    }

    public int getDefaultFuse(IExplosiveEntity ent) {
        return 160;
    }

    public static class DesertPyramid
    extends DesertPyramidStructure {
        public DesertPyramid(Structure.StructureSettings settings) {
            super(settings);
        }

        public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext ctx) {
            return DesertPyramid.m_226585_((Structure.GenerationContext)ctx, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, p -> this.generatePieces((StructurePiecesBuilder)p, ctx));
        }

        private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext ctx) {
            ChunkPos chunkpos = ctx.f_226628_();
            SinglePieceStructure.PieceConstructor constructor = DesertPyramidPiece::new;
            builder.m_142679_(constructor.m_226549_(ctx.f_226626_(), chunkpos.m_45604_(), chunkpos.m_45605_()));
        }
    }

    public static class Monument
    extends OceanMonumentStructure {
        public Monument(Structure.StructureSettings settings) {
            super(settings);
        }

        public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext ctx) {
            return Monument.m_226585_((Structure.GenerationContext)ctx, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, p -> Monument.generatePieces(p, ctx));
        }

        private static StructurePiece createTopPiece(ChunkPos pos, WorldgenRandom rand) {
            int i = pos.m_45604_() - 29;
            int j = pos.m_45605_() - 29;
            Direction direction = Direction.Plane.HORIZONTAL.m_235690_((RandomSource)rand);
            return new OceanMonumentPieces.MonumentBuilding((RandomSource)rand, i, j, direction);
        }

        private static void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext ctx) {
            builder.m_142679_(Monument.createTopPiece(ctx.f_226628_(), ctx.f_226626_()));
        }
    }
}

