/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import luckytnt.entity.PrimedResetTNT;
import luckytnt.registry.BlockRegistry;
import luckytntlib.block.LTNTBlock;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ExplosionHelper;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ResetTNTEffect
extends PrimedTNTEffect {
    public void explosionTick(IExplosiveEntity entity) {
        PrimedResetTNT ent;
        if (entity instanceof PrimedResetTNT && (ent = (PrimedResetTNT)entity).getTNTFuse() == 2400) {
            this.saveBlocks(ent);
            this.saveEntities(ent);
        }
    }

    public void serverExplosion(IExplosiveEntity entity) {
        if (entity instanceof PrimedResetTNT) {
            PrimedResetTNT ent = (PrimedResetTNT)entity;
            for (Pair<BlockPos, BlockState> pair : ent.blocks) {
                if (ent.getLevel().m_8055_((BlockPos)pair.getFirst()).equals(pair.getSecond())) continue;
                ent.getLevel().m_7731_((BlockPos)pair.getFirst(), (BlockState)pair.getSecond(), 3);
            }
            for (Pair<BlockPos, BlockState> pair : ent.entities) {
                Player pla;
                if (((Entity)pair.getSecond()).m_6084_() && !(pair.getSecond() instanceof Player)) {
                    ((Entity)pair.getSecond()).m_146884_((Vec3)pair.getFirst());
                    continue;
                }
                Object object = pair.getSecond();
                if (!(object instanceof Player) || !((pla = (Player)object) instanceof ServerPlayer)) continue;
                ServerPlayer player = (ServerPlayer)pla;
                player.m_6021_(((Vec3)pair.getFirst()).f_82479_, ((Vec3)pair.getFirst()).f_82480_, ((Vec3)pair.getFirst()).f_82481_);
            }
        }
    }

    public void saveBlocks(final PrimedResetTNT ent) {
        ent.blocks = Lists.newArrayList();
        ExplosionHelper.doSphericalExplosion((Level)ent.getLevel(), (Vec3)ent.getPos(), (int)100, (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                if (!(state.m_60734_() instanceof LTNTBlock)) {
                    ent.blocks.add((Pair<BlockPos, BlockState>)Pair.of((Object)pos, (Object)state));
                }
            }
        });
    }

    public void saveEntities(PrimedResetTNT ent) {
        ent.entities = Lists.newArrayList();
        List list = ent.getLevel().m_45933_((Entity)ent, new AABB(ent.x() - 100.0, ent.y() - 100.0, ent.z() - 100.0, ent.x() + 100.0, ent.y() + 100.0, ent.z() + 100.0));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            ent.entities.add((Pair<Vec3, Entity>)Pair.of((Object)new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()), (Object)entity));
        }
    }

    public Block getBlock() {
        return (Block)BlockRegistry.RESET_TNT.get();
    }

    public int getDefaultFuse(IExplosiveEntity ent) {
        return 2400;
    }
}

