/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.util.function.Supplier;
import luckytntlib.block.LTNTBlock;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ExplosionHelper;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class OceanTNTEffect
extends PrimedTNTEffect {
    private final int radius;
    private final int radiusY;
    private final int squidCound;
    private Supplier<RegistryObject<LTNTBlock>> block;

    public OceanTNTEffect(Supplier<RegistryObject<LTNTBlock>> block, int radius, int radiusY, int squidCount) {
        this.radius = radius;
        this.radiusY = radiusY;
        this.squidCound = squidCount;
        this.block = block;
    }

    public OceanTNTEffect(int radius, int radiusY, int squidCount) {
        this.radius = radius;
        this.radiusY = radiusY;
        this.squidCound = squidCount;
    }

    public void serverExplosion(final IExplosiveEntity entity) {
        final ImprovedExplosion dummyExplosion = ImprovedExplosion.dummyExplosion((Level)entity.getLevel());
        ExplosionHelper.doCylindricalExplosion((Level)entity.getLevel(), (Vec3)entity.getPos(), (int)this.radius, (int)this.radiusY, (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                if ((double)pos.m_123342_() <= entity.getPos().f_82480_ && (!state.m_60783_((BlockGetter)level, pos, Direction.UP) && state.getExplosionResistance((BlockGetter)level, pos, (Explosion)dummyExplosion) < 100.0f || state.getExplosionResistance((BlockGetter)level, pos, (Explosion)dummyExplosion) < 4.0f)) {
                    state.onBlockExploded(level, pos, (Explosion)dummyExplosion);
                    level.m_46597_(pos, Blocks.f_49990_.m_49966_());
                }
            }
        });
        for (int i = 0; i < this.squidCound; ++i) {
            Squid squid = new Squid(EntityType.f_20480_, entity.getLevel());
            squid.m_6034_(entity.x() + (Math.random() * (double)this.radius * 2.0 - (double)this.radius), entity.y(), entity.z() + (Math.random() * (double)this.radius * 2.0 - (double)this.radius));
            entity.getLevel().m_7967_((Entity)squid);
        }
    }

    public void spawnParticles(IExplosiveEntity ent) {
        ent.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123769_, ent.x(), ent.y() + (double)0.7f, ent.z(), 0.0, 0.0, 0.0);
    }

    public Block getBlock() {
        return (Block)this.block.get().get();
    }

    public int getDefaultFuse(IExplosiveEntity entity) {
        return 160;
    }
}

