/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import luckytnt.registry.BlockRegistry;
import luckytnt.registry.EffectRegistry;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ExplosionHelper;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.IForEachEntityExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class NuclearTNTEffect
extends PrimedTNTEffect {
    private final int strength;

    public NuclearTNTEffect(int strength) {
        this.strength = strength;
    }

    public void serverExplosion(IExplosiveEntity entity) {
        final ImprovedExplosion explosion = new ImprovedExplosion(entity.getLevel(), (Entity)entity, entity.getPos(), this.strength);
        explosion.doEntityExplosion((float)this.strength / 10.0f, true);
        explosion.doEntityExplosion(new IForEachEntityExplosionEffect(){

            public void doEntityExplosion(Entity entity, double distance) {
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    living.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.CONTAMINATED_EFFECT.get(), 48 * NuclearTNTEffect.this.strength));
                }
            }
        });
        explosion.doBlockExplosion(1.0f, 1.3f, 1.0f, 1.0f, false, false);
        ExplosionHelper.doSphericalExplosion((Level)entity.getLevel(), (Vec3)entity.getPos(), (int)(this.strength * 3), (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                if (state.m_60734_() instanceof BushBlock || state.m_60734_() instanceof LeavesBlock) {
                    state.onBlockExploded(level, pos, (Explosion)explosion);
                }
            }
        });
        explosion.doBlockExplosion(new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                BlockState stateAbove = level.m_8055_(pos.m_7494_());
                if (stateAbove.m_60795_() && !state.m_60795_() && Math.random() < (double)0.33f) {
                    level.m_46597_(pos.m_7494_(), ((Block)BlockRegistry.NUCLEAR_WASTE.get()).m_49966_());
                }
            }
        });
    }

    public void spawnParticles(IExplosiveEntity entity) {
        entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.9f, 1.0f, 0.0f), 1.0f), entity.x(), entity.y() + 1.0, entity.z(), 0.0, 0.0, 0.0);
    }

    public Block getBlock() {
        return (Block)BlockRegistry.NUCLEAR_TNT.get();
    }

    public int getDefaultFuse(IExplosiveEntity entity) {
        return 200;
    }
}

