/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.util.Random;
import javax.annotation.Nullable;
import luckytnt.registry.BlockRegistry;
import luckytnt.registry.EntityRegistry;
import luckytntlib.entity.PrimedLTNT;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class NewYearsFireworkEffect
extends PrimedTNTEffect {
    public void serverExplosion(IExplosiveEntity ent) {
        if (ent.getPersistentData().m_128451_("type") == 0) {
            for (int count = 0; count < 10; ++count) {
                Vec3 vel = ((Entity)ent).m_20252_(1.0f).m_82541_();
                PrimedLTNT firework = (PrimedLTNT)((EntityType)EntityRegistry.NEW_YEARS_FIREWORK.get()).m_20615_(ent.getLevel());
                firework.setTNTFuse(40);
                firework.m_146884_(ent.getPos());
                firework.m_20256_(vel.m_82490_(2.0));
                firework.getPersistentData().m_128405_("type", 1);
                ent.getLevel().m_7967_((Entity)firework);
                ((Entity)ent).m_146922_(((Entity)ent).m_146908_() + 36.0f);
            }
        } else {
            Block block = this.getRandomConcrete();
            Shape shape = Shape.byName(ent.getPersistentData().m_128461_("shape"));
            switch (shape) {
                case SPHERE: {
                    if (!(Math.random() < 0.75)) break;
                    double phi = Math.PI * (3.0 - Math.sqrt(5.0));
                    for (int i = 0; i < 300; ++i) {
                        double y = 1.0 - (double)i / 299.0 * 2.0;
                        double radius = Math.sqrt(1.0 - y * y);
                        double theta = phi * (double)i;
                        double x = Math.cos(theta) * radius;
                        double z = Math.sin(theta) * radius;
                        Vec3 vec = new Vec3(ent.x() + x * 20.0 - ent.x(), ent.y() + y * 20.0 - ent.y(), ent.z() + z * 20.0 - ent.z()).m_82541_().m_82490_(1.0 + Math.random() * 0.5);
                        this.addFallingBlock(ent.x(), ent.y(), ent.z(), vec.f_82479_, vec.f_82480_, vec.f_82481_, block.m_49966_(), ent);
                    }
                    break;
                }
                case CREEPER: {
                    this.createShape(1.0, new double[][]{{0.0, 0.2}, {0.2, 0.2}, {0.2, 0.6}, {0.6, 0.6}, {0.6, 0.2}, {0.2, 0.2}, {0.2, 0.0}, {0.4, 0.0}, {0.4, -0.6}, {0.2, -0.6}, {0.2, -0.4}, {0.0, -0.4}}, true, block.m_49966_(), ent);
                    break;
                }
                case STAR: {
                    this.createShape(1.0, new double[][]{{0.0, 1.0}, {0.3455, 0.309}, {0.9511, 0.309}, {0.3795918367346939, -0.12653061224489795}, {0.6122448979591837, -0.8040816326530612}, {0.0, -0.35918367346938773}}, false, block.m_49966_(), ent);
                    break;
                }
            }
        }
    }

    public void explosionTick(IExplosiveEntity ent) {
        ((Entity)ent).m_20334_(((Entity)ent).m_20184_().f_82479_, (double)0.8f, ((Entity)ent).m_20184_().f_82481_);
        if (ent.getPersistentData().m_128461_("shape").equals("")) {
            String string = "";
            int rand = new Random().nextInt(5);
            switch (rand) {
                case 0: {
                    string = Shape.SPHERE.m_7912_();
                    break;
                }
                case 1: {
                    string = Shape.SPHERE.m_7912_();
                    break;
                }
                case 2: {
                    string = Shape.STAR.m_7912_();
                    break;
                }
                case 3: {
                    string = Shape.STAR.m_7912_();
                    break;
                }
                case 4: {
                    string = Shape.CREEPER.m_7912_();
                    break;
                }
            }
            ent.getPersistentData().m_128359_("shape", string);
        }
    }

    public void spawnParticles(IExplosiveEntity ent) {
        ent.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123744_, ent.x(), ent.y(), ent.z(), 0.0, 0.0, 0.0);
    }

    public void addFallingBlock(double x, double y, double z, double mX, double mY, double mZ, BlockState state, IExplosiveEntity ent) {
        FallingBlockEntity block = FallingBlockEntity.m_201971_((Level)ent.getLevel(), (BlockPos)new BlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z)), (BlockState)state);
        block.f_31943_ = false;
        block.m_20334_(mX, mY, mZ);
        ent.getLevel().m_7967_((Entity)block);
        Level level = ent.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            for (ServerPlayer player : sl.m_6907_()) {
                if (!(player.m_20270_((Entity)ent) <= 100.0f)) continue;
                player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)block));
            }
        }
    }

    public void createShape(double speed, double[][] shape, boolean flag, BlockState state, IExplosiveEntity ent) {
        double d0 = shape[0][0];
        double d1 = shape[0][1];
        this.addFallingBlock(ent.x(), ent.y(), ent.z(), d0 * speed, d1 * speed, 0.0, state, ent);
        float f = new Random().nextFloat() * (float)Math.PI;
        double d2 = flag ? 0.034 : 0.34;
        int i = flag ? 1 : 3;
        for (int k = 0; k < i; ++k) {
            double d3 = (double)f + (double)((float)k * (float)Math.PI) * d2;
            double d4 = d0;
            double d5 = d1;
            for (int j = 1; j < shape.length; ++j) {
                double d6 = shape[j][0];
                double d7 = shape[j][1];
                for (double d8 = 0.25; d8 <= 1.0; d8 += 0.25) {
                    double d9 = Mth.m_14139_((double)d8, (double)d4, (double)d6) * speed;
                    double d10 = Mth.m_14139_((double)d8, (double)d5, (double)d7) * speed;
                    double d11 = d9 * Math.sin(d3);
                    d9 *= Math.cos(d3);
                    for (double d12 = -1.0; d12 <= 1.0; d12 += 2.0) {
                        this.addFallingBlock(ent.x(), ent.y(), ent.z(), d9 * d12, d10, d11 * d12, state, ent);
                    }
                }
                d4 = d6;
                d5 = d7;
            }
        }
    }

    public Block getBlock() {
        return (Block)BlockRegistry.NEW_YEARS_FIREWORK.get();
    }

    public int getDefaultFuse(IExplosiveEntity ent) {
        return 40;
    }

    public Block getRandomConcrete() {
        Block template = null;
        int rand = new Random().nextInt(12);
        switch (rand) {
            case 0: {
                template = Blocks.f_50504_;
                break;
            }
            case 1: {
                template = Blocks.f_50503_;
                break;
            }
            case 2: {
                template = Blocks.f_50501_;
                break;
            }
            case 3: {
                template = Blocks.f_50494_;
                break;
            }
            case 4: {
                template = Blocks.f_50502_;
                break;
            }
            case 5: {
                template = Blocks.f_50499_;
                break;
            }
            case 6: {
                template = Blocks.f_50495_;
                break;
            }
            case 7: {
                template = Blocks.f_50500_;
                break;
            }
            case 8: {
                template = Blocks.f_50496_;
                break;
            }
            case 9: {
                template = Blocks.f_50544_;
                break;
            }
            case 10: {
                template = Blocks.f_50543_;
                break;
            }
            case 11: {
                template = Blocks.f_50545_;
            }
        }
        return template;
    }

    public static enum Shape implements StringRepresentable
    {
        SPHERE("sphere"),
        STAR("star"),
        CREEPER("creeper");

        private static final StringRepresentable.EnumCodec<Shape> CODEC;
        private final String name;

        private Shape(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        @Nullable
        public static Shape byName(@Nullable String name) {
            return (Shape)CODEC.m_216455_(name);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Shape::values);
        }
    }
}

