/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import luckytnt.registry.BlockRegistry;
import luckytnt.util.Materials;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ExplosionHelper;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.structures.NetherFossilPieces;
import net.minecraft.world.level.levelgen.structure.structures.NetherFossilStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.joml.Vector3f;

public class NetherTNTEffect
extends PrimedTNTEffect {
    public List<Block> list = List.of(Blocks.f_50134_, Blocks.f_50699_, Blocks.f_50690_, Blocks.f_50135_, Blocks.f_50136_);

    public void serverExplosion(final IExplosiveEntity ent) {
        ExplosionHelper.doSphericalExplosion((Level)ent.getLevel(), (Vec3)new Vec3(ent.x(), 0.0, ent.z()), (int)40, (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                if (state.getExplosionResistance((BlockGetter)level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)level)) <= 200.0f) {
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        });
        ImprovedExplosion explosion = new ImprovedExplosion(ent.getLevel(), new Vec3(ent.x(), 0.0, ent.z()), 100);
        explosion.doBlockExplosion(1.0f, 0.8f, 1.0f, 0.2f, false, true);
        ExplosionHelper.doSphericalExplosion((Level)ent.getLevel(), (Vec3)new Vec3(ent.x(), 0.0, ent.z()), (int)100, (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                if ((state.m_60734_() instanceof LiquidBlock || state.m_60734_() instanceof BubbleColumnBlock || Materials.isWaterPlant(state)) && pos.m_123342_() <= 50) {
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
                if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && pos.m_123342_() <= 50) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
                }
            }
        });
        final ImprovedExplosion explosion3 = new ImprovedExplosion(ent.getLevel(), new Vec3(ent.x(), 0.0, ent.z()), 80);
        explosion3.doBlockExplosion(1.0f, 0.8f, 1.0f, 0.2f, true, new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                if (state.getExplosionResistance((BlockGetter)level, pos, (Explosion)explosion3) <= 200.0f && !state.m_60742_((BlockGetter)level, pos, CollisionContext.m_82749_()).m_83281_()) {
                    level.m_7731_(pos, Blocks.f_50134_.m_49966_(), 3);
                }
            }
        });
        ExplosionHelper.doCylindricalExplosion((Level)ent.getLevel(), (Vec3)new Vec3(ent.x(), -40.0, ent.z()), (int)40, (int)20, (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                if (pos.m_123342_() <= -44 && state.m_60795_()) {
                    level.m_7731_(pos, Blocks.f_49991_.m_49966_(), 3);
                }
            }
        });
        final int biome = new Random().nextInt(3);
        ImprovedExplosion explosion4 = new ImprovedExplosion(ent.getLevel(), new Vec3(ent.x(), 0.0, ent.z()), 80);
        explosion4.doBlockExplosion(1.0f, 0.8f, 1.0f, 0.2f, true, new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                BlockPos posAbove = pos.m_7494_();
                BlockState stateAbove = level.m_8055_(posAbove);
                if (stateAbove.m_60795_() && state.m_60734_() == Blocks.f_50134_ && pos.m_123342_() <= -10) {
                    if (biome == 0) {
                        level.m_7731_(pos, Blocks.f_50699_.m_49966_(), 3);
                    }
                    if (biome == 1) {
                        level.m_7731_(pos, Blocks.f_50690_.m_49966_(), 3);
                    }
                    if (biome == 2) {
                        level.m_7731_(pos, Blocks.f_50135_.m_49966_(), 3);
                    }
                }
            }
        });
        ImprovedExplosion explosion5 = new ImprovedExplosion(ent.getLevel(), new Vec3(ent.x(), 0.0, ent.z()), 150);
        explosion5.doBlockExplosion(1.0f, 0.8f, 1.0f, 0.2f, true, new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                Registry registry;
                BlockPos posBelow = pos.m_7495_();
                BlockState stateBelow = level.m_8055_(posBelow);
                BlockPos posAbove = pos.m_7494_();
                BlockState stateAbove = level.m_8055_(posAbove);
                if (NetherTNTEffect.this.list.contains(state.m_60734_()) && stateAbove.m_60795_() && pos.m_123342_() <= -10) {
                    registry = (Registry)ent.getLevel().m_9598_().m_6632_(Registries.f_256911_).get();
                    if (biome == 0) {
                        if (Math.random() < 0.02) {
                            ((ConfiguredFeature)registry.m_6246_(NetherFeatures.f_195046_)).m_224953_((WorldGenLevel)ent.getLevel(), ((ServerLevel)ent.getLevel()).m_7726_().m_8481_(), RandomSource.m_216327_(), posAbove);
                        }
                        if (Math.random() < 0.04) {
                            ((ConfiguredFeature)registry.m_6246_(TreeFeatures.f_195117_)).m_224953_((WorldGenLevel)ent.getLevel(), ((ServerLevel)ent.getLevel()).m_7726_().m_8481_(), RandomSource.m_216327_(), posAbove);
                        }
                        if (Math.random() < 0.02) {
                            ((ConfiguredFeature)registry.m_6246_(NetherFeatures.f_195037_)).m_224953_((WorldGenLevel)ent.getLevel(), ((ServerLevel)ent.getLevel()).m_7726_().m_8481_(), RandomSource.m_216327_(), posAbove);
                        }
                    }
                    if (biome == 1) {
                        if (Math.random() < 0.02) {
                            ((ConfiguredFeature)registry.m_6246_(NetherFeatures.f_195042_)).m_224953_((WorldGenLevel)ent.getLevel(), ((ServerLevel)ent.getLevel()).m_7726_().m_8481_(), RandomSource.m_216327_(), posAbove);
                        }
                        if (Math.random() < 0.01) {
                            ((ConfiguredFeature)registry.m_6246_(NetherFeatures.f_195044_)).m_224953_((WorldGenLevel)ent.getLevel(), ((ServerLevel)ent.getLevel()).m_7726_().m_8481_(), RandomSource.m_216327_(), posAbove);
                        }
                        if (Math.random() < 0.04) {
                            ((ConfiguredFeature)registry.m_6246_(TreeFeatures.f_195119_)).m_224953_((WorldGenLevel)ent.getLevel(), ((ServerLevel)ent.getLevel()).m_7726_().m_8481_(), RandomSource.m_216327_(), posAbove);
                        }
                        if (Math.random() < 0.02) {
                            ((ConfiguredFeature)registry.m_6246_(NetherFeatures.f_195040_)).m_224953_((WorldGenLevel)ent.getLevel(), ((ServerLevel)ent.getLevel()).m_7726_().m_8481_(), RandomSource.m_216327_(), posAbove);
                        }
                    }
                    if (biome == 2) {
                        if (Math.random() < 0.025) {
                            DiskConfiguration config = new DiskConfiguration(RuleBasedBlockStateProvider.m_225936_((Block)Blocks.f_50136_), BlockPredicate.m_198311_(List.of(Blocks.f_50134_, Blocks.f_50135_, Blocks.f_50136_)), (IntProvider)UniformInt.m_146622_((int)3, (int)6), 2);
                            Feature.f_65781_.m_225028_((FeatureConfiguration)config, (WorldGenLevel)ent.getLevel(), ((ServerLevel)ent.getLevel()).m_7726_().m_8481_(), RandomSource.m_216327_(), pos);
                        }
                        if (Math.random() < 0.01) {
                            ((ConfiguredFeature)registry.m_6246_(NetherFeatures.f_195052_)).m_224953_((WorldGenLevel)ent.getLevel(), ((ServerLevel)ent.getLevel()).m_7726_().m_8481_(), RandomSource.m_216327_(), posAbove);
                        }
                        if (Math.random() < 0.001) {
                            NetherFossil structure = new NetherFossil(null, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)pos.m_123342_())), level);
                            StructureStart start = structure.m_226596_(ent.getLevel().m_9598_(), ((ServerLevel)ent.getLevel()).m_7726_().m_8481_(), ((ServerLevel)ent.getLevel()).m_7726_().m_8481_().m_62218_(), ((ServerLevel)ent.getLevel()).m_7726_().m_214994_(), ((ServerLevel)ent.getLevel()).m_215082_(), ((ServerLevel)ent.getLevel()).m_7328_(), new ChunkPos(posAbove), 20, (LevelHeightAccessor)level, holder -> true);
                            start.m_226850_((WorldGenLevel)ent.getLevel(), ((ServerLevel)ent.getLevel()).m_215010_(), ((ServerLevel)ent.getLevel()).m_7726_().m_8481_(), RandomSource.m_216327_(), new BoundingBox(pos.m_123341_() - 150, pos.m_123342_() - 150, pos.m_123343_() - 150, pos.m_123341_() + 150, pos.m_123342_() + 150, pos.m_123343_() + 150), new ChunkPos(posAbove));
                        }
                    }
                }
                if (stateBelow.m_60795_() && state.m_60734_() == Blocks.f_50134_ && pos.m_123342_() >= 10 && Math.random() < 0.005) {
                    registry = (Registry)ent.getLevel().m_9598_().m_6632_(Registries.f_256911_).get();
                    ((ConfiguredFeature)registry.m_6246_(NetherFeatures.f_195034_)).m_224953_((WorldGenLevel)ent.getLevel(), ((ServerLevel)ent.getLevel()).m_7726_().m_8481_(), RandomSource.m_216327_(), posBelow);
                }
            }
        });
    }

    public void spawnParticles(IExplosiveEntity ent) {
        if (ent.getTNTFuse() % 3 == 0) {
            double d;
            for (d = 0.0; d <= 1.5; d += 0.1) {
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 0.75f), ent.x() + 0.5, ent.y() + 1.1 + d, ent.z(), 0.0, 0.0, 0.0);
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 0.75f), ent.x() + 0.4, ent.y() + 1.1 + d, ent.z(), 0.0, 0.0, 0.0);
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 0.75f), ent.x() - 0.5, ent.y() + 1.1 + d, ent.z(), 0.0, 0.0, 0.0);
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 0.75f), ent.x() - 0.4, ent.y() + 1.1 + d, ent.z(), 0.0, 0.0, 0.0);
            }
            for (d = 0.0; d <= 1.0; d += 0.1) {
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 0.75f), ent.x() + 0.5 - d, ent.y() + 1.1, ent.z(), 0.0, 0.0, 0.0);
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 0.75f), ent.x() + 0.5 - d, ent.y() + 1.2, ent.z(), 0.0, 0.0, 0.0);
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 0.75f), ent.x() + 0.5 - d, ent.y() + 2.6, ent.z(), 0.0, 0.0, 0.0);
                ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 0.75f), ent.x() + 0.5 - d, ent.y() + 2.5, ent.z(), 0.0, 0.0, 0.0);
            }
            for (double x = -0.3; x <= 0.3; x += 0.1) {
                for (double y = 0.2; y <= 1.3; y += 0.1) {
                    ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.5f, 0.0f, 1.0f), 0.75f), ent.x() + x + 0.05, ent.y() + 1.1 + y, ent.z(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public Block getBlock() {
        return (Block)BlockRegistry.NETHER_TNT.get();
    }

    public int getDefaultFuse(IExplosiveEntity ent) {
        return 180;
    }

    public class NetherFossil
    extends NetherFossilStructure {
        private final Level level;

        public NetherFossil(Structure.StructureSettings settings, HeightProvider height, Level level) {
            super(settings, height);
            this.level = level;
        }

        public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext ctx) {
            WorldgenRandom worldgenrandom = ctx.f_226626_();
            int i = ctx.f_226628_().m_45604_() + worldgenrandom.m_188503_(16);
            int j = ctx.f_226628_().m_45605_() + worldgenrandom.m_188503_(16);
            int k = -64;
            int l = 0;
            while (l > k) {
                BlockState blockstate = this.level.m_8055_(new BlockPos(i, l, j));
                BlockState blockstate1 = this.level.m_8055_(new BlockPos(i, --l, j));
                if (!blockstate.m_60795_() || !blockstate1.m_60713_(Blocks.f_50135_) && !blockstate1.m_60713_(Blocks.f_50136_) && !blockstate1.m_60713_(Blocks.f_50134_)) continue;
                break;
            }
            if (l <= k) {
                return Optional.empty();
            }
            BlockPos blockpos = new BlockPos(i, l, j);
            return Optional.of(new Structure.GenerationStub(blockpos, accessor -> NetherFossilPieces.m_228534_((StructureTemplateManager)ctx.f_226625_(), (StructurePieceAccessor)accessor, (RandomSource)worldgenrandom, (BlockPos)blockpos)));
        }
    }
}

