/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import luckytnt.registry.BlockRegistry;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ExplosionHelper;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class LushTNTEffect
extends PrimedTNTEffect {
    private final int radius;

    public LushTNTEffect(int radius) {
        this.radius = radius;
    }

    public void serverExplosion(final IExplosiveEntity entity) {
        ExplosionHelper.doSphericalExplosion((Level)entity.getLevel(), (Vec3)entity.getPos(), (int)this.radius, (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                if (state.getExplosionResistance((BlockGetter)level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)entity.getLevel())) < 100.0f && (!state.m_60838_((BlockGetter)level, pos) || state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13106_))) {
                    state.onBlockExploded(level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)entity.getLevel()));
                }
            }
        });
        ExplosionHelper.doSphericalExplosion((Level)entity.getLevel(), (Vec3)entity.getPos(), (int)Math.round((float)this.radius * 0.75f), (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                if (level.m_8055_(pos.m_7495_()).m_60795_() && !state.m_60795_() && state.getExplosionResistance((BlockGetter)level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)entity.getLevel())) < 100.0f && !state.m_204336_(BlockTags.f_144277_)) {
                    state.onBlockExploded(level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)entity.getLevel()));
                    level.m_46597_(pos, Blocks.f_50069_.m_49966_());
                } else if (level.m_8055_(pos.m_7495_()).getExplosionResistance((BlockGetter)level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)entity.getLevel())) < 100.0f && !level.m_8055_(pos.m_7495_()).m_60795_() && state.m_60795_() && !level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144277_)) {
                    state.onBlockExploded(level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)entity.getLevel()));
                    level.m_46597_(pos.m_7495_(), Blocks.f_50069_.m_49966_());
                }
            }
        });
        Level level = entity.getLevel();
        if (level instanceof ServerLevel) {
            final ServerLevel sLevel = (ServerLevel)level;
            ExplosionHelper.doSphericalExplosion((Level)sLevel, (Vec3)entity.getPos(), (int)Math.round((float)this.radius * 0.75f), (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

                public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                    Holder.Reference feature;
                    if (level.m_8055_(pos.m_7495_()).m_60795_() && !state.m_60795_() && Math.random() < (double)0.025f) {
                        feature = entity.getLevel().m_9598_().m_175515_(Registries.f_256911_).m_246971_(CaveFeatures.f_194956_);
                        ((ConfiguredFeature)feature.m_203334_()).m_224953_((WorldGenLevel)sLevel, sLevel.m_7726_().m_8481_(), sLevel.f_46441_, pos);
                    }
                    if (!level.m_8055_(pos.m_7495_()).m_60795_() && state.m_60795_() && Math.random() < (double)0.1f) {
                        feature = null;
                        if (Math.random() < 0.5) {
                            feature = entity.getLevel().m_9598_().m_175515_(Registries.f_256911_).m_246971_(CaveFeatures.f_194955_);
                            ((ConfiguredFeature)feature.m_203334_()).m_224953_((WorldGenLevel)sLevel, sLevel.m_7726_().m_8481_(), sLevel.f_46441_, pos);
                        } else {
                            feature = entity.getLevel().m_9598_().m_175515_(Registries.f_256911_).m_246971_(CaveFeatures.f_194950_);
                            ((ConfiguredFeature)feature.m_203334_()).m_224953_((WorldGenLevel)sLevel, sLevel.m_7726_().m_8481_(), sLevel.f_46441_, pos);
                        }
                    }
                }
            });
        }
    }

    public void spawnParticles(IExplosiveEntity entity) {
        int count;
        for (count = 0; count <= 20; ++count) {
            entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.36f, 0.27f, 0.11f), 0.75f), entity.x() + Math.random() * 0.0625 - Math.random() * 0.0625, entity.y() + 1.0 + Math.random() * 0.375, entity.z() + Math.random() * 0.0625 - Math.random() * 0.0625, 0.0, 0.0, 0.0);
        }
        for (count = 0; count <= 60; ++count) {
            entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.44f, 0.57f, 0.18f), 0.75f), entity.x() + Math.random() * 0.75 - Math.random() * 0.75, entity.y() + 1.0 + 0.375 + Math.random() * 0.625, entity.z() + Math.random() * 0.75 - Math.random() * 0.75, 0.0, 0.0, 0.0);
        }
        for (count = 0; count <= 10; ++count) {
            entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.82f, 0.48f, 0.89f), 0.75f), entity.x() + Math.random() * 0.75 - Math.random() * 0.75, entity.y() + 1.0 + 0.375 + Math.random() * 0.625, entity.z() + Math.random() * 0.75 - Math.random() * 0.75, 0.0, 0.0, 0.0);
        }
    }

    public Block getBlock() {
        return (Block)BlockRegistry.LUSH_TNT.get();
    }
}

