/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.util.List;
import luckytnt.registry.BlockRegistry;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class KnockbackTNTEffect
extends PrimedTNTEffect {
    public void explosionTick(IExplosiveEntity ent) {
        if (ent.getTNTFuse() > 1) {
            List ents = ent.getLevel().m_45976_(LivingEntity.class, new AABB(ent.x() - 75.0, ent.y() - 75.0, ent.z() - 75.0, ent.x() + 75.0, ent.y() + 75.0, ent.z() + 75.0));
            for (LivingEntity lent : ents) {
                Player player;
                if (lent.getPersistentData().m_128451_("knockbacktime") > 0) {
                    lent.getPersistentData().m_128405_("knockbacktime", lent.getPersistentData().m_128451_("knockbacktime") - 1);
                }
                double x = ent.x() - lent.m_20185_();
                double y = ent.y() - lent.m_20186_();
                double z = ent.z() - lent.m_20189_();
                double distance = Math.sqrt(x * x + y * y + z * z) + 0.1;
                Vec3 vec = new Vec3(x, y, z).m_82541_().m_82490_(1.0 / (distance * 0.2) + 0.5).m_82520_(0.0, 0.1, 0.0);
                if (distance > 2.1 && distance <= 75.0 && lent.getPersistentData().m_128451_("knockbacktime") <= 0) {
                    if (lent instanceof Player) {
                        player = (Player)lent;
                        if (player.m_7500_()) continue;
                        lent.m_20256_(vec);
                        continue;
                    }
                    lent.m_20256_(vec);
                    continue;
                }
                if (!(distance <= 2.1)) continue;
                if (lent instanceof Player) {
                    player = (Player)lent;
                    if (player.m_7500_()) continue;
                    lent.getPersistentData().m_128405_("knockbacktime", 40);
                    lent.m_20256_(vec.m_82548_().m_82541_().m_82490_(5.0).m_82520_(0.0, 0.5, 0.0));
                    continue;
                }
                lent.getPersistentData().m_128405_("knockbacktime", 40);
                lent.m_20256_(vec.m_82548_().m_82541_().m_82490_(5.0).m_82520_(0.0, 0.5, 0.0));
            }
        }
    }

    public void serverExplosion(IExplosiveEntity ent) {
        List entities = ent.getLevel().m_45933_((Entity)ent, new AABB(ent.x() - 75.0, ent.y() - 75.0, ent.z() - 75.0, ent.x() + 75.0, ent.y() + 75.0, ent.z() + 75.0));
        for (Entity entity : entities) {
            double distance;
            if (entity.m_6128_() || !((distance = Math.sqrt(entity.m_20238_(ent.getPos())) / 150.0) <= 1.0)) continue;
            double offX = entity.m_20185_() - ent.x();
            double offY = entity.m_20188_() - ent.y();
            double offZ = entity.m_20189_() - ent.z();
            double distance2 = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
            float damage = 1.0f - (float)distance;
            entity.m_20256_(entity.m_20184_().m_82520_((offX /= distance2) * (double)damage * 15.0, (offY /= distance2) * (double)damage * 15.0, (offZ /= distance2) * (double)damage * 15.0));
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            player.f_19864_ = true;
        }
    }

    public void spawnParticles(IExplosiveEntity ent) {
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        for (int i = 0; i < 600; ++i) {
            double y = 1.0 - (double)i / 599.0 * 2.0;
            double radius = Math.sqrt(1.0 - y * y);
            double theta = phi * (double)i;
            double x = Math.cos(theta) * radius;
            double z = Math.sin(theta) * radius;
            ent.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.2f, 0.8f, 0.2f), 0.75f), ent.x() + x * 2.0, ent.y() + 0.5 + y * 2.0, ent.z() + 2.0 * z, 0.0, 0.0, 0.0);
        }
    }

    public Block getBlock() {
        return (Block)BlockRegistry.KNOCKBACK_TNT.get();
    }

    public int getDefaultFuse(IExplosiveEntity ent) {
        return 300;
    }
}

