/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.util.Random;
import luckytnt.registry.BlockRegistry;
import luckytnt.util.Materials;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ExplosionHelper;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;

public class JungleTNTEffect
extends PrimedTNTEffect {
    public void serverExplosion(final IExplosiveEntity ent) {
        JungleTNTEffect.replaceNonSolidBlockOrVegetationWithAir(ent, 150.0, 99.0f, true);
        ExplosionHelper.doSphericalExplosion((Level)ent.getLevel(), (Vec3)ent.getPos(), (int)150, (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                BlockPos posTop = pos.m_7918_(0, 1, 0);
                BlockState stateTop = level.m_8055_(posTop);
                if (state.getExplosionResistance((BlockGetter)level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)ent.getLevel())) < 100.0f && stateTop.getExplosionResistance((BlockGetter)level, posTop, (Explosion)ImprovedExplosion.dummyExplosion((Level)ent.getLevel())) < 100.0f && Block.m_49918_((VoxelShape)state.m_60812_((BlockGetter)level, pos), (Direction)Direction.UP) && (stateTop.m_60795_() || Materials.isPlant(stateTop) || stateTop.m_204336_(BlockTags.f_144279_))) {
                    state.m_60734_().onBlockExploded(state, level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)ent.getLevel()));
                    level.m_7731_(pos, Blocks.f_50440_.m_49966_(), 3);
                }
            }
        });
        JungleTNTEffect.doJungleExplosion(ent, 150.0);
    }

    public Block getBlock() {
        return (Block)BlockRegistry.JUNGLE_TNT.get();
    }

    public int getDefaultFuse(IExplosiveEntity ent) {
        return 160;
    }

    public static void replaceNonSolidBlockOrVegetationWithAir(IExplosiveEntity ent, double radius, float maxResistance, boolean vegetation) {
        if (!ent.getLevel().m_5776_()) {
            for (double offX = -radius; offX <= radius; offX += 1.0) {
                for (double offY = radius; offY >= -radius; offY -= 1.0) {
                    for (double offZ = -radius; offZ <= radius; offZ += 1.0) {
                        double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
                        BlockPos pos = new BlockPos(Mth.m_14107_((double)(ent.x() + offX)), Mth.m_14107_((double)(ent.y() + offY)), Mth.m_14107_((double)(ent.z() + offZ)));
                        BlockState state = ent.getLevel().m_8055_(pos);
                        if (!(distance <= radius) || !(state.getExplosionResistance((BlockGetter)ent.getLevel(), pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)ent.getLevel())) <= maxResistance) || state.m_60795_() || (state.m_60838_((BlockGetter)ent.getLevel(), pos) || state.m_60713_(Blocks.f_220864_) || state.m_204336_(Tags.Blocks.CHESTS)) && (!vegetation || !state.m_204336_(BlockTags.f_13035_) && !state.m_204336_(BlockTags.f_13106_) && state.m_60734_() != Blocks.f_220833_)) continue;
                        if (Materials.isWaterPlant(state)) {
                            Block block1 = state.m_60734_();
                            block1.onBlockExploded(state, ent.getLevel(), pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)ent.getLevel()));
                            ent.getLevel().m_7731_(pos, Blocks.f_49990_.m_49966_(), 3);
                            continue;
                        }
                        state.m_60734_().onBlockExploded(state, ent.getLevel(), pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)ent.getLevel()));
                    }
                }
            }
        }
    }

    public static void doJungleExplosion(IExplosiveEntity ent, double radius) {
        Registry registry = ent.getLevel().m_9598_().m_175515_(Registries.f_256952_);
        Holder biome = registry.m_263177_((Object)((Biome)registry.m_6246_(Biomes.f_48222_)));
        for (double offX = -radius; offX < radius; offX += 1.0) {
            for (double offZ = -radius; offZ < radius; offZ += 1.0) {
                boolean foundBlock = false;
                double distance = Math.sqrt(offX * offX + offZ * offZ);
                if (ent.getLevel().m_5776_() || !(distance < radius)) continue;
                if (offX % 16.0 == 0.0 && offZ % 16.0 == 0.0) {
                    for (LevelChunkSection section : ent.getLevel().m_46865_(new BlockPos(Mth.m_14107_((double)(ent.x() + offX)), 0, Mth.m_14107_((double)(ent.z() + offZ)))).m_7103_()) {
                        PalettedContainerRO biomesRO = section.m_187996_();
                        for (int i = 0; i < 4; ++i) {
                            for (int j = 0; j < 4; ++j) {
                                for (int k = 0; k < 4; ++k) {
                                    PalettedContainer biomes;
                                    if (!(biomesRO instanceof PalettedContainer) || (biomes = (PalettedContainer)biomesRO).m_63087_(i, j, k) == biome) continue;
                                    biomes.m_63127_(i, j, k, (Object)biome);
                                }
                            }
                        }
                    }
                }
                for (ServerPlayer player : ((ServerLevel)ent.getLevel()).m_6907_()) {
                    player.f_8906_.m_9829_((Packet)new ClientboundLevelChunkWithLightPacket(ent.getLevel().m_46745_(new BlockPos(Mth.m_14107_((double)(ent.x() + offX)), 0, Mth.m_14107_((double)(ent.z() + offZ)))), ent.getLevel().m_5518_(), null, null));
                }
                Registry features = ent.getLevel().m_9598_().m_175515_(Registries.f_256911_);
                ConfiguredFeature patch_melon = (ConfiguredFeature)features.m_6246_(VegetationFeatures.f_195186_);
                ConfiguredFeature trees_jungle = (ConfiguredFeature)features.m_6246_(VegetationFeatures.f_195170_);
                ConfiguredFeature patch_grass_jungle = (ConfiguredFeature)features.m_6246_(VegetationFeatures.f_195183_);
                for (double offY = 320.0; offY > -64.0; offY -= 1.0) {
                    BlockPos pos = new BlockPos(Mth.m_14107_((double)(ent.x() + offX)), Mth.m_14107_((double)(ent.y() + offY)), Mth.m_14107_((double)(ent.z() + offZ)));
                    BlockState state = ent.getLevel().m_8055_(pos);
                    if (foundBlock || !state.m_60838_((BlockGetter)ent.getLevel(), pos) || state.m_60795_() || ent.getLevel().m_8055_(pos.m_7494_()).m_60734_() instanceof LiquidBlock) continue;
                    if (offX % 30.0 == 0.0 && offZ % 30.0 == 0.0) {
                        patch_melon.m_224953_((WorldGenLevel)((ServerLevel)ent.getLevel()), ((ServerLevel)ent.getLevel()).m_7726_().m_8481_(), RandomSource.m_216327_(), pos.m_7494_());
                    }
                    int random = new Random().nextInt(3);
                    switch (random) {
                        case 0: {
                            trees_jungle.m_224953_((WorldGenLevel)((ServerLevel)ent.getLevel()), ((ServerLevel)ent.getLevel()).m_7726_().m_8481_(), RandomSource.m_216327_(), pos.m_7494_());
                            break;
                        }
                        case 1: {
                            patch_grass_jungle.m_224953_((WorldGenLevel)((ServerLevel)ent.getLevel()), ((ServerLevel)ent.getLevel()).m_7726_().m_8481_(), RandomSource.m_216327_(), pos.m_7494_());
                        }
                    }
                    foundBlock = true;
                }
            }
        }
    }
}

