/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.lang.reflect.Field;
import luckytnt.entity.PrimedItemFirework;
import luckytnt.registry.BlockRegistry;
import luckytntlib.item.LDynamiteItem;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.SpectralArrowItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class ItemFireworkEffect
extends PrimedTNTEffect {
    public void explosionTick(IExplosiveEntity ent) {
        ((Entity)ent).m_20334_(((Entity)ent).m_20184_().f_82479_, (double)0.8f, ((Entity)ent).m_20184_().f_82481_);
    }

    public void serverExplosion(IExplosiveEntity entity) {
        block34: {
            if (!(entity instanceof PrimedItemFirework)) break block34;
            PrimedItemFirework ent = (PrimedItemFirework)entity;
            Item item = ent.item;
            ItemStack stack = ent.stack == null ? ItemStack.f_41583_ : ent.stack;
            stack.m_41764_(1);
            if (item == null) {
                item = Item.m_41445_((int)ent.getPersistentData().m_128451_("itemID"));
            }
            if (item != null) {
                if (item instanceof BoatItem) {
                    BoatItem boatitem = (BoatItem)item;
                    boolean hasChest = false;
                    Boat.Type type = Boat.Type.OAK;
                    try {
                        Field chest = BoatItem.class.getDeclaredField("hasChest");
                        Field boattype = BoatItem.class.getDeclaredField("type");
                        chest.setAccessible(true);
                        boattype.setAccessible(true);
                        hasChest = chest.getBoolean(boatitem);
                        type = (Boat.Type)boattype.get(boatitem);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                        e.printStackTrace();
                    }
                    for (int i = 0; i < 300; ++i) {
                        Boat boat = new Boat(ent.getLevel(), ent.x(), ent.y(), ent.z());
                        if (hasChest) {
                            boat = new ChestBoat(ent.getLevel(), ent.x(), ent.y(), ent.z());
                        }
                        boat.m_28464_(type);
                        boat.m_20334_(Math.random() * 6.0 - 3.0, Math.random() * 6.0 - 3.0, Math.random() * 6.0 - 3.0);
                        ent.getLevel().m_7967_((Entity)boat);
                    }
                } else if (item instanceof FireChargeItem) {
                    double phi = Math.PI * (3.0 - Math.sqrt(5.0));
                    for (int i = 0; i < 300; ++i) {
                        double y = 1.0 - (double)i / 299.0 * 2.0;
                        double radius = Math.sqrt(1.0 - y * y);
                        double theta = phi * (double)i;
                        double x = Math.cos(theta) * radius;
                        double z = Math.sin(theta) * radius;
                        LargeFireball fireball = new LargeFireball(EntityType.f_20463_, ent.getLevel());
                        fireball.m_6034_(ent.x() + x * 15.0, ent.y() + y * 15.0, ent.z() + z * 15.0);
                        Vec3 vec = new Vec3(fireball.m_20185_() - ent.x(), fireball.m_20186_() - ent.y(), fireball.m_20189_() - ent.z()).m_82541_().m_82490_(0.5);
                        fireball.f_36813_ = vec.f_82479_;
                        fireball.f_36814_ = vec.f_82480_;
                        fireball.f_36815_ = vec.f_82481_;
                        ent.getLevel().m_7967_((Entity)fireball);
                    }
                } else if (item == Items.f_42735_) {
                    for (int i = 0; i < 300; ++i) {
                        DragonFireball fireball = new DragonFireball(EntityType.f_20561_, ent.getLevel());
                        fireball.m_146884_(ent.getPos());
                        fireball.f_36813_ = Math.random() - 0.5;
                        fireball.f_36814_ = Math.random() - 0.5;
                        fireball.f_36815_ = Math.random() - 0.5;
                        ent.getLevel().m_7967_((Entity)fireball);
                    }
                } else if (item instanceof ThrowablePotionItem) {
                    for (int i = 0; i < 300; ++i) {
                        ThrownPotion potion = new ThrownPotion(ent.getLevel(), ent.x(), ent.y(), ent.z());
                        potion.m_37446_(stack != null ? stack : new ItemStack((ItemLike)item));
                        potion.m_20334_(Math.random() * 3.0 - 1.5, Math.random() * 3.0 - 1.5, Math.random() * 3.0 - 1.5);
                        ent.getLevel().m_7967_((Entity)potion);
                    }
                } else if (item instanceof ArrowItem) {
                    for (int count = 0; count < 300; ++count) {
                        SpectralArrow arrow;
                        if (item instanceof SpectralArrowItem) {
                            arrow = new SpectralArrow(ent.getLevel(), ent.x(), ent.y(), ent.z());
                            arrow.m_20334_(Math.random() * 6.0 - 3.0, Math.random() * 6.0 - 3.0, Math.random() * 6.0 - 3.0);
                            ent.getLevel().m_7967_((Entity)arrow);
                            continue;
                        }
                        arrow = new Arrow(ent.getLevel(), ent.x(), ent.y(), ent.z());
                        arrow.m_36878_(stack == null ? new ItemStack((ItemLike)item) : stack);
                        arrow.m_20334_(Math.random() * 6.0 - 3.0, Math.random() * 6.0 - 3.0, Math.random() * 6.0 - 3.0);
                        ent.getLevel().m_7967_((Entity)arrow);
                    }
                } else if (item instanceof EggItem) {
                    for (int count = 0; count < 300; ++count) {
                        ThrownEgg egg = new ThrownEgg(ent.getLevel(), ent.x(), ent.y(), ent.z());
                        egg.m_20334_(Math.random() * 3.0 - 1.5, Math.random() * 3.0 - 1.5, Math.random() * 3.0 - 1.5);
                        ent.getLevel().m_7967_((Entity)egg);
                    }
                } else if (item instanceof SnowballItem) {
                    for (int count = 0; count < 300; ++count) {
                        Snowball ball = new Snowball(ent.getLevel(), ent.x(), ent.y(), ent.z());
                        ball.m_20334_(Math.random() * 3.0 - 1.5, Math.random() * 3.0 - 1.5, Math.random() * 3.0 - 1.5);
                        ent.getLevel().m_7967_((Entity)ball);
                    }
                } else if (item instanceof LDynamiteItem) {
                    LDynamiteItem dynamite = (LDynamiteItem)item;
                    for (int count = 0; count < 300; ++count) {
                        dynamite.shoot(ent.getLevel(), ent.x(), ent.y(), ent.z(), new Vec3(Math.random() * 6.0 - 3.0, Math.random() * 6.0 - 3.0, Math.random() * 6.0 - 3.0), 1.0f + (float)Math.random(), null);
                    }
                } else if (item instanceof FireworkRocketItem) {
                    for (int count = 0; count < 300; ++count) {
                        FireworkRocketEntity rocket = new FireworkRocketEntity(ent.getLevel(), stack == null ? new ItemStack((ItemLike)item) : stack, ent.x(), ent.y(), ent.z(), true);
                        rocket.m_20334_(Math.random() * 2.0 - 1.0, Math.random() * 2.0 - 1.0, Math.random() * 2.0 - 1.0);
                        ent.getLevel().m_7967_((Entity)rocket);
                    }
                } else {
                    for (int i = 0; i < 300; ++i) {
                        ItemEntity itement = new ItemEntity(ent.getLevel(), ent.x(), ent.y(), ent.z(), stack == null ? new ItemStack((ItemLike)item) : stack.m_41777_());
                        itement.m_20334_(Math.random() * 3.0 - 1.5, Math.random() * 3.0 - 1.5, Math.random() * 3.0 - 1.5);
                        ent.getLevel().m_7967_((Entity)itement);
                    }
                }
            }
        }
    }

    public void spawnParticles(IExplosiveEntity ent) {
        ent.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123744_, ent.x(), ent.y(), ent.z(), 0.0, 0.0, 0.0);
    }

    public Block getBlock() {
        return (Block)BlockRegistry.ITEM_FIREWORK.get();
    }

    public int getDefaultFuse(IExplosiveEntity ent) {
        return 40;
    }
}

