/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.util.List;
import luckytnt.network.ClientboundIntNBTPacket;
import luckytnt.network.PacketHandler;
import luckytnt.registry.BlockRegistry;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class HungryTNTEffect
extends PrimedTNTEffect {
    public void explosionTick(IExplosiveEntity ent) {
        LivingEntity target = null;
        double distance = 2000.0;
        List list = ent.getLevel().m_45976_(LivingEntity.class, new AABB(ent.x() - 50.0, ent.y() - 50.0, ent.z() - 50.0, ent.x() + 50.0, ent.y() + 50.0, ent.z() + 50.0));
        for (LivingEntity living : list) {
            double z;
            double y;
            double x = living.m_20185_() - ent.x();
            double magnitude = Math.sqrt(x * x + (y = living.m_20188_() - ent.y()) * y + (z = living.m_20189_() - ent.z()) * z);
            if (!(magnitude < distance)) continue;
            distance = magnitude;
            target = living;
        }
        if (target != null) {
            double z;
            double y;
            double x = ent.x() - target.m_20185_();
            double magnitude = Math.sqrt(x * x + (y = ent.y() - target.m_20186_()) * y + (z = ent.z() - target.m_20189_()) * z);
            if (magnitude > 2.0) {
                Vec3 vec3d = new Vec3(x, y + 0.1, z).m_82541_();
                if (!(target instanceof Player)) {
                    target.m_20256_(vec3d);
                } else if (target instanceof Player) {
                    target.m_20256_(vec3d.m_82490_(0.3));
                }
            } else if (magnitude <= 2.0) {
                if (!(target instanceof Player)) {
                    ent.getPersistentData().m_128405_("amount", ent.getPersistentData().m_128451_("amount") + 1);
                    if (!ent.getLevel().m_5776_()) {
                        PacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> (Entity)ent), (Object)new ClientboundIntNBTPacket("amount", ent.getPersistentData().m_128451_("amount"), ((Entity)ent).m_19879_()));
                    }
                    target.m_146870_();
                } else if (target instanceof Player) {
                    DamageSources sources = new DamageSources(ent.getLevel().m_9598_());
                    target.m_6469_(sources.m_269341_(), 4.0f);
                    Vec3 vec3d = new Vec3(target.m_20185_() - ent.x(), target.m_20186_() - ent.y(), target.m_20189_() - ent.z()).m_82541_().m_82490_(10.0);
                    target.m_20256_(vec3d);
                }
            }
        }
    }

    public void serverExplosion(IExplosiveEntity ent) {
        int amount = ent.getPersistentData().m_128451_("amount");
        if (amount < 0) {
            amount = 0;
        }
        if (amount > 20) {
            amount = 20;
        }
        float size = 80.0f + 4.0f * (float)amount;
        float yStrength = 1.3f - 0.015000001f * (float)amount;
        float resistanceImpact = 1.0f - 0.04165f * (float)amount;
        float knockback = 5.0f + 0.5f * (float)amount;
        ImprovedExplosion explosion = new ImprovedExplosion(ent.getLevel(), (Entity)ent, ent.getPos(), Mth.m_14107_((double)size));
        explosion.doEntityExplosion(knockback, true);
        explosion.doBlockExplosion(1.0f, yStrength, resistanceImpact, size >= 110.0f ? 0.05f : 1.0f, false, size >= 110.0f);
    }

    public float getSize(IExplosiveEntity ent) {
        int amount = ent.getPersistentData().m_128451_("amount");
        if (amount < 0) {
            amount = 0;
        }
        if (amount > 20) {
            amount = 20;
        }
        return 1.0f + 0.15f * (float)amount;
    }

    public Block getBlock() {
        return (Block)BlockRegistry.HUNGRY_TNT.get();
    }

    public int getDefaultFuse(IExplosiveEntity ent) {
        return 600;
    }
}

