/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.util.Random;
import luckytnt.registry.BlockRegistry;
import luckytnt.util.Noise3D;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ExplosionHelper;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class HoneyTNTEffect
extends PrimedTNTEffect {
    private final int radius;

    public HoneyTNTEffect(int radius) {
        this.radius = radius;
    }

    public void serverExplosion(final IExplosiveEntity entity) {
        final Noise3D noise = new Noise3D(this.radius * 4, this.radius * 4, this.radius * 4, 5);
        ExplosionHelper.doModifiedSphericalExplosion((Level)entity.getLevel(), (Vec3)entity.getPos(), (int)this.radius, (Vec3)new Vec3(1.0, 1.5, 1.0), (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                if (state.getExplosionResistance((BlockGetter)level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)entity.getLevel())) <= 200.0f) {
                    if ((distance += Math.random()) <= (double)(HoneyTNTEffect.this.radius - 2)) {
                        state.onBlockExploded(level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)entity.getLevel()));
                        if (distance >= (double)(HoneyTNTEffect.this.radius - 3) && Math.random() < (double)0.05f) {
                            level.m_46597_(pos, (BlockState)((BlockState)Blocks.f_50717_.m_49966_().m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)HoneyTNTEffect.this.getRandomDirectionHorizontal())).m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(new Random().nextInt(6))));
                        }
                        if (Math.random() < (double)0.025f) {
                            Bee bee = new Bee(EntityType.f_20550_, level);
                            bee.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                            level.m_7967_((Entity)bee);
                        }
                    } else if (distance <= (double)HoneyTNTEffect.this.radius) {
                        int offX = Math.round((float)pos.m_123341_() - (float)entity.x());
                        int offY = Math.round((float)pos.m_123342_() - (float)entity.y());
                        int offZ = Math.round((float)pos.m_123343_() - (float)entity.z());
                        state.onBlockExploded(level, pos, (Explosion)ImprovedExplosion.dummyExplosion((Level)entity.getLevel()));
                        if (noise.getValue(Mth.m_14045_((int)(offX + HoneyTNTEffect.this.radius), (int)0, (int)(HoneyTNTEffect.this.radius * 4)), Mth.m_14045_((int)((int)((float)offY + (float)HoneyTNTEffect.this.radius * 1.5f)), (int)0, (int)(HoneyTNTEffect.this.radius * 4)), Mth.m_14045_((int)(offZ + HoneyTNTEffect.this.radius), (int)0, (int)(HoneyTNTEffect.this.radius * 4))) > (double)0.7f) {
                            level.m_46597_(pos, Blocks.f_50719_.m_49966_());
                        } else {
                            level.m_46597_(pos, Blocks.f_50720_.m_49966_());
                        }
                    }
                }
            }
        });
    }

    public void spawnParticles(IExplosiveEntity entity) {
        entity.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123779_, entity.x(), entity.y(), entity.z(), 0.0, 0.0, 0.0);
    }

    public Block getBlock() {
        return (Block)BlockRegistry.HONEY_TNT.get();
    }

    public int getDefaultFuse(IExplosiveEntity entity) {
        return 120;
    }

    public Direction getRandomDirectionHorizontal() {
        int random = new Random().nextInt(4);
        switch (random) {
            case 0: {
                return Direction.NORTH;
            }
            case 1: {
                return Direction.EAST;
            }
            case 2: {
                return Direction.SOUTH;
            }
            case 3: {
                return Direction.WEST;
            }
        }
        return Direction.NORTH;
    }
}

