/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.util.function.Supplier;
import luckytntlib.block.LTNTBlock;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ExplosionHelper;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class FlatTNTEffect
extends PrimedTNTEffect {
    private final int radius;
    private final int radiusY;
    private int fuse = 80;
    private Supplier<RegistryObject<LTNTBlock>> block;

    public FlatTNTEffect(int radius, int radiusY, int fuse) {
        this.radius = radius;
        this.radiusY = radiusY;
        this.fuse = fuse;
    }

    public FlatTNTEffect(Supplier<RegistryObject<LTNTBlock>> block, int radius, int radiusY, int fuse) {
        this.radius = radius;
        this.radiusY = radiusY;
        this.block = block;
        this.fuse = fuse;
    }

    public void serverExplosion(final IExplosiveEntity entity) {
        final ImprovedExplosion dummyExplosion = ImprovedExplosion.dummyExplosion((Level)entity.getLevel());
        ExplosionHelper.doCylindricalExplosion((Level)entity.getLevel(), (Vec3)entity.getPos(), (int)this.radius, (int)this.radiusY, (IForEachBlockExplosionEffect)new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                if ((double)pos.m_123342_() >= entity.y() - 0.5 && state.getExplosionResistance((BlockGetter)level, pos, (Explosion)dummyExplosion) <= 100.0f) {
                    state.onBlockExploded(level, pos, (Explosion)dummyExplosion);
                }
            }
        });
    }

    public Block getBlock() {
        return (Block)this.block.get().get();
    }

    public int getDefaultFuse(IExplosiveEntity ent) {
        return this.fuse;
    }
}

