/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.util.List;
import luckytnt.registry.BlockRegistry;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;

public class EntityFireworkEffect
extends PrimedTNTEffect {
    public void explosionTick(IExplosiveEntity ent) {
        ((Entity)ent).m_20334_(((Entity)ent).m_20184_().f_82479_, (double)0.8f, ((Entity)ent).m_20184_().f_82481_);
        if (ent.getTNTFuse() == 40) {
            List ents = ent.getLevel().m_45976_(LivingEntity.class, new AABB(ent.x() - 20.0, ent.y() - 20.0, ent.z() - 20.0, ent.x() + 20.0, ent.y() + 20.0, ent.z() + 20.0));
            double distance = 2000.0;
            for (LivingEntity lent : ents) {
                double zD;
                double yD;
                double xD = lent.m_20185_() - ent.x();
                double d = Math.sqrt(xD * xD + (yD = lent.m_20186_() - ent.y()) * yD + (zD = lent.m_20189_() - ent.z()) * zD);
                if (!(d < distance) || lent instanceof Player) continue;
                distance = d;
                ent.getPersistentData().m_128359_("type", EntityType.m_20613_((EntityType)lent.m_6095_()).toString());
            }
        }
    }

    public void serverExplosion(IExplosiveEntity ent) {
        EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(ent.getPersistentData().m_128461_("type")));
        if (type == null) {
            type = EntityType.f_20510_;
        }
        for (int count = 0; count < 300; ++count) {
            Entity lent = type.m_20615_(ent.getLevel());
            lent.m_6034_(ent.x(), ent.y(), ent.z());
            lent.m_20334_(Math.random() * 3.0 - 1.5, Math.random() * 3.0 - 1.5, Math.random() * 3.0 - 1.5);
            if (lent instanceof Mob) {
                Mob mob = (Mob)lent;
                Level level = ent.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel sLevel = (ServerLevel)level;
                    mob.m_6518_((ServerLevelAccessor)sLevel, sLevel.m_6436_(this.toBlockPos(ent.getPos())), MobSpawnType.MOB_SUMMONED, null, null);
                }
            }
            ent.getLevel().m_7967_(lent);
        }
    }

    public void spawnParticles(IExplosiveEntity ent) {
        ent.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123744_, ent.x(), ent.y(), ent.z(), 0.0, 0.0, 0.0);
    }

    public Block getBlock() {
        return (Block)BlockRegistry.ENTITY_FIREWORK.get();
    }

    public int getDefaultFuse(IExplosiveEntity ent) {
        return 40;
    }
}

