/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import luckytnt.registry.BlockRegistry;
import luckytnt.registry.EntityRegistry;
import luckytntlib.entity.PrimedLTNT;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.IForEachBlockExplosionEffect;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;

public class EasterEggEffect
extends PrimedTNTEffect {
    public void baseTick(IExplosiveEntity entity) {
        super.baseTick(entity);
        if (((Entity)entity).m_20096_() && ((Entity)entity).getPersistentData().m_128451_("level") > 0) {
            this.serverExplosion(entity);
            Level level = entity.getLevel();
            entity.getLevel().m_245803_((Entity)entity, this.toBlockPos(entity.getPos()), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
            entity.destroy();
        }
    }

    public void serverExplosion(final IExplosiveEntity entity) {
        int level = ((Entity)entity).getPersistentData().m_128451_("level");
        final ImprovedExplosion explosion = new ImprovedExplosion(entity.getLevel(), (Entity)entity, entity.getPos(), 15);
        explosion.doBlockExplosion(1.0f, 1.0f, 1.0f, 1.25f, false, false);
        explosion.doBlockExplosion(new IForEachBlockExplosionEffect(){

            public void doBlockExplosion(Level level, BlockPos pos, BlockState state, double distance) {
                if (Math.random() < (double)0.66f && !state.m_60795_()) {
                    state.onBlockExploded(level, pos, (Explosion)explosion);
                    if (Math.random() < 0.5) {
                        entity.getLevel().m_46597_(pos, Blocks.f_50186_.m_49966_());
                    } else {
                        entity.getLevel().m_46597_(pos, Blocks.f_50133_.m_49966_());
                    }
                }
            }
        });
        if (level + 1 == 4) {
            entity.destroy();
        } else {
            for (int count = 0; count < 4; ++count) {
                PrimedLTNT tnt = (PrimedLTNT)((EntityType)EntityRegistry.EASTER_EGG.get()).m_20615_(entity.getLevel());
                tnt.m_146884_(entity.getPos());
                tnt.setOwner(entity.owner());
                tnt.m_20334_(Math.random() * 2.0 - 1.0, 1.0 + Math.random(), Math.random() * 2.0 - 1.0);
                tnt.getPersistentData().m_128405_("level", level + 1);
                entity.getLevel().m_7967_((Entity)tnt);
            }
        }
    }

    public void spawnParticles(IExplosiveEntity entity) {
        entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.5f, 0.0f), 1.0f), entity.x(), entity.y() + 1.0, entity.z(), 0.0, 0.0, 0.0);
        entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.5f, 0.0f), 1.0f), entity.x() + (double)0.2f, entity.y() + 1.0, entity.z() + (double)0.2f, 0.0, 0.0, 0.0);
        entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.5f, 0.0f), 1.0f), entity.x() - (double)0.2f, entity.y() + 1.0, entity.z() - (double)0.2f, 0.0, 0.0, 0.0);
        entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.5f, 0.0f), 1.0f), entity.x() + (double)0.2f, entity.y() + 1.0, entity.z() - (double)0.2f, 0.0, 0.0, 0.0);
        entity.getLevel().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.5f, 0.0f), 1.0f), entity.x() - (double)0.2f, entity.y() + 1.0, entity.z() + (double)0.2f, 0.0, 0.0, 0.0);
    }

    public Block getBlock() {
        return (Block)BlockRegistry.EASTER_EGG.get();
    }

    public int getDefaultFuse(IExplosiveEntity entity) {
        return 120;
    }
}

