/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.util.HashSet;
import java.util.Optional;
import luckytnt.registry.BlockRegistry;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class DrillingTNTEffect
extends PrimedTNTEffect {
    private static final float VEC_LENGTH = 100.0f;
    private static final float MAX_RESISTANCE = 100.0f;
    private final ExplosionDamageCalculator damageCalculator = new ExplosionDamageCalculator();

    public void serverExplosion(IExplosiveEntity entity) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        ImprovedExplosion dummyExplosion = new ImprovedExplosion(entity.getLevel(), (Entity)entity, entity.getPos(), 4);
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                double distance = Math.sqrt(x * x + z * z);
                if (!(distance <= 3.0)) continue;
                for (float y = 0.0f; y < 100.0f; y += 0.3f) {
                    BlockPos pos = this.toBlockPos(entity.getPos().m_82520_((double)x, (double)(-y), (double)z));
                    BlockState blockState = entity.getLevel().m_8055_(pos);
                    FluidState fluidState = entity.getLevel().m_6425_(pos);
                    Optional explosionResistance = this.damageCalculator.m_6617_((Explosion)dummyExplosion, (BlockGetter)entity.getLevel(), pos, blockState, fluidState);
                    if (explosionResistance.isPresent() && ((Float)explosionResistance.get()).floatValue() > 100.0f) {
                        y += 100.0f;
                        continue;
                    }
                    blocks.add(pos);
                }
            }
        }
        for (BlockPos pos : blocks) {
            entity.getLevel().m_8055_(pos).m_60734_().onBlockExploded(entity.getLevel().m_8055_(pos), entity.getLevel(), pos, (Explosion)dummyExplosion);
        }
    }

    public void spawnParticles(IExplosiveEntity entity) {
        entity.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123762_, entity.x(), entity.y() + (double)1.6f, entity.z(), 0.0, (double)-0.1f, 0.0);
        entity.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123762_, entity.x() + (double)0.4f, entity.y() + (double)1.4f, entity.z() + (double)0.4f, 0.0, (double)-0.1f, 0.0);
        entity.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123762_, entity.x() + (double)0.4f, entity.y() + (double)1.4f, entity.z() - (double)0.4f, 0.0, (double)-0.1f, 0.0);
        entity.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123762_, entity.x() - (double)0.4f, entity.y() + (double)1.4f, entity.z() + (double)0.4f, 0.0, (double)-0.1f, 0.0);
        entity.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123762_, entity.x() - (double)0.4f, entity.y() + (double)1.4f, entity.z() - (double)0.4f, 0.0, (double)-0.1f, 0.0);
    }

    public Block getBlock() {
        return (Block)BlockRegistry.DRILLING_TNT.get();
    }
}

