/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.util.Random;
import luckytnt.registry.BlockRegistry;
import luckytnt.registry.EntityRegistry;
import luckytntlib.entity.PrimedLTNT;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class DividingTNTEffect
extends PrimedTNTEffect {
    public void baseTick(IExplosiveEntity entity) {
        super.baseTick(entity);
        if (entity.getTNTFuse() == 60 && entity.getPersistentData().m_128451_("level") != 0) {
            double x = entity.getPersistentData().m_128459_("x") - entity.x();
            double z = entity.getPersistentData().m_128459_("z") - entity.z();
            double magnitude = Math.sqrt(x * x + z * z) + (double)0.01f;
            ((Entity)entity).m_20334_(x / magnitude, 1.0, z / magnitude);
        }
    }

    public void serverExplosion(IExplosiveEntity entity) {
        if (entity.getPersistentData().m_128451_("level") == 0) {
            for (int offX = -50; offX < 50; offX += 10) {
                block1: for (int offZ = -50; offZ < 50; offZ += 10) {
                    for (int offY = 320; offY > -64; --offY) {
                        BlockPos pos = this.toBlockPos(new Vec3(entity.x() + (double)offX, entity.y() + (double)offY, entity.z() + (double)offZ));
                        if (!entity.getLevel().m_8055_(pos).m_60838_((BlockGetter)entity.getLevel(), pos) || entity.getLevel().m_8055_(pos.m_7494_()).m_60838_((BlockGetter)entity.getLevel(), pos.m_7494_())) continue;
                        PrimedLTNT projectile = (PrimedLTNT)((EntityType)EntityRegistry.DIVIDING_TNT.get()).m_20615_(entity.getLevel());
                        projectile.m_146884_(entity.getPos().m_82520_((double)offX, (double)offY, (double)offZ));
                        projectile.setOwner(entity.owner() instanceof LivingEntity ? entity.owner() : null);
                        projectile.getPersistentData().m_128405_("maxLevel", new Random().nextInt(5));
                        projectile.getPersistentData().m_128405_("level", entity.getPersistentData().m_128451_("level") + 1);
                        projectile.getPersistentData().m_128347_("x", entity.x());
                        projectile.getPersistentData().m_128347_("z", entity.z());
                        entity.getLevel().m_7967_((Entity)projectile);
                        continue block1;
                    }
                }
            }
            entity.destroy();
        } else if (entity.getPersistentData().m_128451_("level") >= entity.getPersistentData().m_128451_("maxLevel")) {
            ImprovedExplosion explosion = new ImprovedExplosion(entity.getLevel(), (Entity)entity, entity.getPos(), 10);
            explosion.doEntityExplosion(1.0f, true);
            explosion.doBlockExplosion();
            if (entity.getPersistentData().m_128451_("level") >= entity.getPersistentData().m_128451_("maxLevel")) {
                Level level = entity.getLevel();
                entity.getLevel().m_245803_((Entity)entity, this.toBlockPos(entity.getPos()), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
            }
            entity.destroy();
        } else {
            ImprovedExplosion explosion = new ImprovedExplosion(entity.getLevel(), (Entity)entity, entity.getPos(), 10);
            explosion.doEntityExplosion(1.5f, true);
            explosion.doBlockExplosion();
            PrimedLTNT projectile = (PrimedLTNT)((EntityType)EntityRegistry.DIVIDING_TNT.get()).m_20615_(entity.getLevel());
            projectile.setOwner(entity.owner() instanceof LivingEntity ? entity.owner() : null);
            projectile.m_146884_(entity.getPos());
            projectile.m_20334_(Math.random() - Math.random(), 1.0 + Math.random() * 0.75, Math.random() - Math.random());
            projectile.getPersistentData().m_128405_("maxLevel", entity.getPersistentData().m_128451_("maxLevel"));
            projectile.getPersistentData().m_128405_("level", entity.getPersistentData().m_128451_("level") + 1);
            projectile.getPersistentData().m_128347_("x", entity.getPersistentData().m_128459_("x"));
            projectile.getPersistentData().m_128347_("z", entity.getPersistentData().m_128459_("z"));
            projectile.m_20334_(0.0, 0.0, 0.0);
            entity.getLevel().m_7967_((Entity)projectile);
        }
    }

    public Block getBlock() {
        return (Block)BlockRegistry.DIVIDING_TNT.get();
    }

    public int getDefaultFuse(IExplosiveEntity entity) {
        return 80;
    }
}

