/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import luckytnt.LevelVariables;
import luckytnt.config.LuckyTNTConfigValues;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class DisasterTNTEffect
extends PrimedTNTEffect {
    private final String disaster;
    private final boolean rain;

    public DisasterTNTEffect(String disaster, boolean rain) {
        this.disaster = disaster;
        this.rain = rain;
    }

    public void serverExplosion(IExplosiveEntity ent) {
        ServerLevel sl;
        Level level;
        LevelVariables var = LevelVariables.get((LevelAccessor)ent.getLevel());
        int time = 1000 * (Integer)LuckyTNTConfigValues.MAXIMUM_DISASTER_TIME.get() + 1000 * (Integer)LuckyTNTConfigValues.MAXIMUM_DISASTER_TIME.get() * (int)Math.random();
        if (this.disaster.equals("doomsday")) {
            var.doomsdayTime = time;
        } else if (this.disaster.equals("toxic_clouds")) {
            var.toxicCloudsTime = time;
        } else if (this.disaster.equals("clear")) {
            var.doomsdayTime = 0;
            var.heatDeathTime = 0;
            var.iceAgeTime = 0;
            var.tntRainTime = 0;
            var.toxicCloudsTime = 0;
            level = ent.getLevel();
            if (level instanceof ServerLevel) {
                sl = (ServerLevel)level;
                sl.m_8606_(1000000, 0, false, false);
            }
        } else if (this.disaster.equals("ice_age")) {
            var.iceAgeTime = time;
        } else if (this.disaster.equals("heat_death")) {
            var.heatDeathTime = time;
        } else if (this.disaster.equals("tnt_rain")) {
            var.tntRainTime = time;
        }
        level = ent.getLevel();
        if (level instanceof ServerLevel) {
            sl = (ServerLevel)level;
            var.sync(sl);
            if (this.rain) {
                sl.m_8606_(0, time, true, true);
            }
        }
    }

    public boolean playsSound() {
        return false;
    }

    public Block getBlock() {
        return Blocks.f_50016_;
    }

    public int getDefaultFuse(IExplosiveEntity entity) {
        return 0;
    }
}

