/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.util.HashSet;
import java.util.Optional;
import luckytnt.registry.BlockRegistry;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.explosions.ImprovedExplosion;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class DiggingTNTEffect
extends PrimedTNTEffect {
    private static final float VEC_LENGTH = 60.0f;
    private static final float MAX_RESISTANCE = 100.0f;
    private final ExplosionDamageCalculator damageCalculator = new ExplosionDamageCalculator();

    public void serverExplosion(IExplosiveEntity entity) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        ImprovedExplosion dummyExplosion = new ImprovedExplosion(entity.getLevel(), (Entity)entity, entity.getPos(), 4);
        for (float y = 0.0f; y < 60.0f; y += 0.3f) {
            BlockPos pos = this.toBlockPos(entity.getPos().m_82520_(0.0, (double)(-y), 0.0));
            BlockState blockState = entity.getLevel().m_8055_(pos);
            FluidState fluidState = entity.getLevel().m_6425_(pos);
            Optional explosionResistance = this.damageCalculator.m_6617_((Explosion)dummyExplosion, (BlockGetter)entity.getLevel(), pos, blockState, fluidState);
            if (explosionResistance.isPresent() && ((Float)explosionResistance.get()).floatValue() > 100.0f) {
                y += 100.0f;
                continue;
            }
            blocks.add(pos);
        }
        for (BlockPos pos : blocks) {
            entity.getLevel().m_8055_(pos).m_60734_().onBlockExploded(entity.getLevel().m_8055_(pos), entity.getLevel(), pos, (Explosion)dummyExplosion);
        }
    }

    public void spawnParticles(IExplosiveEntity entity) {
        entity.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123762_, entity.x(), entity.y() + (double)1.4f, entity.z(), 0.0, (double)-0.1f, 0.0);
    }

    public Block getBlock() {
        return (Block)BlockRegistry.DIGGING_TNT.get();
    }
}

