/*
 * Decompiled with CFR 0.152.
 */
package luckytnt.tnteffects;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import luckytnt.entity.PrimedCustomFirework;
import luckytnt.registry.BlockRegistry;
import luckytntlib.util.IExplosiveEntity;
import luckytntlib.util.tnteffects.PrimedTNTEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CustomFireworkEffect
extends PrimedTNTEffect {
    public void explosionTick(IExplosiveEntity ent) {
        if (ent.getTNTFuse() == 40 && ent instanceof PrimedCustomFirework) {
            PrimedCustomFirework tnt = (PrimedCustomFirework)ent;
            BlockPos pos = this.toBlockPos(new Vec3(ent.x(), ent.y() - 1.0, ent.z()));
            ent.getPersistentData().m_128405_("x", pos.m_123341_());
            ent.getPersistentData().m_128405_("y", pos.m_123342_());
            ent.getPersistentData().m_128405_("z", pos.m_123343_());
            tnt.state = ent.getLevel().m_8055_(pos);
        }
        ((Entity)ent).m_20334_(((Entity)ent).m_20184_().f_82479_, (double)0.8f, ((Entity)ent).m_20184_().f_82481_);
    }

    public void serverExplosion(IExplosiveEntity ent) {
        if (ent instanceof PrimedCustomFirework) {
            PrimedCustomFirework fire = (PrimedCustomFirework)ent;
            BlockState state = ent.getLevel().m_8055_(new BlockPos(ent.getPersistentData().m_128451_("x"), ent.getPersistentData().m_128451_("y"), ent.getPersistentData().m_128451_("z")));
            if (fire.state != null) {
                state = fire.state;
            }
            for (int count = 0; count < 200; ++count) {
                Block block = state.m_60734_();
                if (block instanceof TntBlock) {
                    TntBlock tnt = (TntBlock)block;
                    tnt.onCaughtFire(state, ent.getLevel(), this.toBlockPos(ent.getPos()), null, ent.owner());
                    continue;
                }
                try {
                    Class[] parameters = new Class[]{Level.class, Double.TYPE, Double.TYPE, Double.TYPE, BlockState.class};
                    Constructor sandConstructor = FallingBlockEntity.class.getDeclaredConstructor(parameters);
                    sandConstructor.setAccessible(true);
                    FallingBlockEntity sand = (FallingBlockEntity)sandConstructor.newInstance(ent.getLevel(), ent.getPos().f_82479_, ent.getPos().f_82480_, ent.getPos().f_82481_, state);
                    sand.m_20334_(Math.random() * 1.5 - Math.random() * 1.5, Math.random() * 1.5 - Math.random() * 1.5, Math.random() * 1.5 - Math.random() * 1.5);
                    ent.getLevel().m_7967_((Entity)sand);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            List tnts = ent.getLevel().m_45976_(PrimedTnt.class, new AABB(this.toBlockPos(ent.getPos()).m_7918_(2, 2, 2), this.toBlockPos(ent.getPos()).m_7918_(-2, -2, -2)));
            for (PrimedTnt tnt : tnts) {
                tnt.m_20334_(Math.random() * 1.5 - Math.random() * 1.5, Math.random() * 1.5 - Math.random() * 1.5, Math.random() * 1.5 - Math.random() * 1.5);
            }
        }
    }

    public void spawnParticles(IExplosiveEntity ent) {
        ent.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123744_, ent.x(), ent.y(), ent.z(), 0.0, 0.0, 0.0);
    }

    public Block getBlock() {
        return (Block)BlockRegistry.CUSTOM_FIREWORK.get();
    }

    public int getDefaultFuse(IExplosiveEntity ent) {
        return 40;
    }
}

